/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.decorator;

import java.awt.Color;
import java.awt.Component;
import org.shiftone.jrat.depends.jdesktop.swingx.decorator.ComponentAdapter;
import org.shiftone.jrat.depends.jdesktop.swingx.decorator.LegacyHighlighter;

public abstract class ConditionalHighlighter
extends LegacyHighlighter {
    protected int testColumn = 0;
    protected int highlightColumn = -1;
    protected int mask = 256;

    public ConditionalHighlighter() {
    }

    public ConditionalHighlighter(Color cellBackground, Color cellForeground, int testColumn, int highlightColumn) {
        super(cellBackground, cellForeground);
        this.testColumn = testColumn;
        this.highlightColumn = highlightColumn;
    }

    public void setMask(int alpha) {
        this.mask = alpha;
        this.fireStateChanged();
    }

    public int getMask() {
        return this.mask;
    }

    public Component highlight(Component renderer, ComponentAdapter adapter) {
        if (this.needsHighlight(adapter)) {
            return this.doHighlight(renderer, adapter);
        }
        if (this.getMask() < 256) {
            return this.doMask(renderer, adapter);
        }
        return renderer;
    }

    protected Component doMask(Component renderer, ComponentAdapter adapter) {
        this.maskBackground(renderer, adapter);
        this.maskForeground(renderer, adapter);
        return renderer;
    }

    protected void maskBackground(Component renderer, ComponentAdapter adapter) {
        Color color;
        Color seed = renderer.getBackground();
        Color color2 = color = adapter.isSelected() ? this.computeSelectedBackground(seed) : seed;
        if (color != null) {
            renderer.setBackground(new Color(this.getMask() << 24 | color.getRGB() & 0xFFFFFF, true));
        }
    }

    protected void maskForeground(Component renderer, ComponentAdapter adapter) {
        Color color;
        Color seed = renderer.getForeground();
        Color color2 = color = adapter.isSelected() ? this.computeSelectedForeground(seed) : seed;
        if (color != null) {
            renderer.setForeground(new Color(this.getMask() << 24 | color.getRGB() & 0xFFFFFF, true));
        }
    }

    @Deprecated
    protected Color computeSelectedForeground(Color seed) {
        return this.getSelectedForeground() == null ? (seed == null ? null : seed.brighter()) : this.getSelectedForeground();
    }

    public int getTestColumnIndex() {
        return this.testColumn;
    }

    public void setTestColumnIndex(int columnIndex) {
        this.testColumn = columnIndex;
        this.fireStateChanged();
    }

    public int getHighlightColumnIndex() {
        return this.highlightColumn;
    }

    public void setHighlightColumnIndex(int columnIndex) {
        this.highlightColumn = columnIndex;
        this.fireStateChanged();
    }

    protected boolean needsHighlight(ComponentAdapter adapter) {
        if (this.highlightColumn < 0 || this.highlightColumn == adapter.viewToModel(adapter.column)) {
            return this.test(adapter);
        }
        return false;
    }

    protected abstract boolean test(ComponentAdapter var1);
}

