/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.decorator;

import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.shiftone.jrat.depends.jdesktop.swingx.decorator.ComponentAdapter;
import org.shiftone.jrat.depends.jdesktop.swingx.util.Contract;

public interface HighlightPredicate {
    public static final HighlightPredicate ALWAYS = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return true;
        }
    };
    public static final HighlightPredicate NEVER = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return false;
        }
    };
    public static final HighlightPredicate ROLLOVER_ROW = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            if (!adapter.getComponent().isEnabled()) {
                return false;
            }
            Point p = (Point)adapter.getComponent().getClientProperty("swingx.rollover");
            return p != null && p.y == adapter.row;
        }
    };
    public static final HighlightPredicate EDITABLE = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.isEditable();
        }
    };
    public static final HighlightPredicate EVEN = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.row % 2 == 0;
        }
    };
    public static final HighlightPredicate ODD = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return !EVEN.isHighlighted(renderer, adapter);
        }
    };

    public boolean isHighlighted(Component var1, ComponentAdapter var2);

    public static class EqualsHighlightPredicate
    implements HighlightPredicate {
        private Object compareValue;

        public EqualsHighlightPredicate() {
            this(null);
        }

        public EqualsHighlightPredicate(Object compareValue) {
            this.compareValue = compareValue;
        }

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            if (this.compareValue == null) {
                return adapter.getValue() == null;
            }
            return this.compareValue.equals(adapter.getValue());
        }
    }

    public static class DepthHighlightPredicate
    implements HighlightPredicate {
        private List<Integer> depthList = new ArrayList<Integer>();

        public DepthHighlightPredicate(int ... depths) {
            for (int i = 0; i < depths.length; ++i) {
                this.depthList.add(depths[i]);
            }
        }

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            int depth = adapter.getDepth();
            return this.depthList.contains(depth);
        }
    }

    public static class ColumnHighlightPredicate
    implements HighlightPredicate {
        List<Integer> columnList = new ArrayList<Integer>();

        public ColumnHighlightPredicate(int ... columns) {
            for (int i = 0; i < columns.length; ++i) {
                this.columnList.add(columns[i]);
            }
        }

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            int modelIndex = adapter.viewToModel(adapter.column);
            return this.columnList.contains(modelIndex);
        }
    }

    public static class RowGroupHighlightPredicate
    implements HighlightPredicate {
        private int linesPerGroup;

        public RowGroupHighlightPredicate(int linesPerGroup) {
            if (linesPerGroup < 1) {
                throw new IllegalArgumentException("a group contain at least 1 row, was: " + linesPerGroup);
            }
            this.linesPerGroup = linesPerGroup;
        }

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.row / this.linesPerGroup % 2 == 1;
        }
    }

    public static class OrHighlightPredicate
    implements HighlightPredicate {
        private List<HighlightPredicate> predicate;

        public OrHighlightPredicate(HighlightPredicate ... predicate) {
            this.predicate = Arrays.asList((Object[])Contract.asNotNull(predicate, "predicate must not be null"));
        }

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            for (HighlightPredicate hp : this.predicate) {
                if (!hp.isHighlighted(renderer, adapter)) continue;
                return true;
            }
            return false;
        }
    }

    public static class AndHighlightPredicate
    implements HighlightPredicate {
        private List<HighlightPredicate> predicate;

        public AndHighlightPredicate(HighlightPredicate ... predicate) {
            this.predicate = Arrays.asList((Object[])Contract.asNotNull(predicate, "predicate must not be null"));
        }

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            for (HighlightPredicate hp : this.predicate) {
                if (hp.isHighlighted(renderer, adapter)) continue;
                return false;
            }
            return true;
        }
    }

    public static class NotHighlightPredicate
    implements HighlightPredicate {
        private HighlightPredicate predicate;

        public NotHighlightPredicate(HighlightPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException("predicate must not be null");
            }
            this.predicate = predicate;
        }

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return !this.predicate.isHighlighted(renderer, adapter);
        }
    }
}

