/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.decorator;

import java.awt.Color;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.shiftone.jrat.depends.jdesktop.swingx.decorator.ComponentAdapter;
import org.shiftone.jrat.depends.jdesktop.swingx.decorator.ConditionalHighlighter;
import org.shiftone.jrat.depends.jdesktop.swingx.decorator.PatternMatcher;

public class PatternHighlighter
extends ConditionalHighlighter
implements PatternMatcher {
    protected Pattern pattern = null;

    public PatternHighlighter() {
        this(null, null, null, 0, 0);
    }

    public PatternHighlighter(Color background, Color foreground, String regExString, int matchFlags, int testColumn) throws PatternSyntaxException {
        this(background, foreground, regExString, matchFlags, testColumn, -1);
    }

    public PatternHighlighter(Color background, Color foreground, String regExString, int matchFlags, int testColumn, int decorateColumn) throws PatternSyntaxException {
        super(background, foreground, testColumn, decorateColumn);
        this.setPattern(regExString, matchFlags);
    }

    protected boolean test(ComponentAdapter adapter) {
        if (this.pattern == null) {
            return false;
        }
        if (!adapter.isTestable(this.testColumn)) {
            return false;
        }
        Object value = adapter.getFilteredValueAt(adapter.row, this.testColumn);
        if (value == null) {
            return false;
        }
        return this.pattern.matcher(value.toString()).find();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(String regularExpr, int matchFlags) {
        if (regularExpr == null || regularExpr.length() == 0) {
            regularExpr = ".*";
        }
        this.setPattern(Pattern.compile(regularExpr, matchFlags));
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
        this.fireStateChanged();
    }
}

