/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditorSupport;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.shiftone.jrat.depends.jdesktop.swingx.JXList;
import org.shiftone.jrat.depends.jdesktop.swingx.JXPanel;
import org.shiftone.jrat.depends.jdesktop.swingx.JXTitledPanel;
import org.shiftone.jrat.depends.jdesktop.swingx.decorator.AlternateRowHighlighter;
import org.shiftone.jrat.depends.jdesktop.swingx.decorator.CompoundHighlighter;
import org.shiftone.jrat.depends.jdesktop.swingx.decorator.Highlighter;
import org.shiftone.jrat.depends.jdesktop.swingx.decorator.LegacyHighlighter;
import org.shiftone.jrat.depends.jdesktop.swingx.decorator.PatternHighlighter;

public class HighlighterPropertyEditor
extends PropertyEditorSupport {
    private CompoundHighlighter pipeline = new CompoundHighlighter(new Highlighter[0]);
    private Editor editor = new Editor();

    public HighlighterPropertyEditor() {
        this.editor.highlightersList.setModel((ListModel)new AbstractListModel(){

            public Object getElementAt(int index) {
                return HighlighterPropertyEditor.this.pipeline.getHighlighters()[index];
            }

            public int getSize() {
                return HighlighterPropertyEditor.this.pipeline.getHighlighters().length;
            }
        });
        this.editor.highlightersList.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                HighlighterPropertyEditor.this.firePropertyChange();
            }

            public void intervalAdded(ListDataEvent e) {
                HighlighterPropertyEditor.this.firePropertyChange();
            }

            public void intervalRemoved(ListDataEvent e) {
                HighlighterPropertyEditor.this.firePropertyChange();
            }
        });
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public String getJavaInitializationString() {
        StringBuffer buffer = new StringBuffer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(300);
        XMLEncoder e = new XMLEncoder(baos);
        e.writeObject(this.pipeline.getHighlighters());
        e.close();
        Highlighter[] blar = (Highlighter[])new XMLDecoder(new ByteArrayInputStream(baos.toString().getBytes())).readObject();
        buffer.append("new org.jdesktop.swingx.decorator.CompoundHighlighter(\n");
        buffer.append("\t(org.jdesktop.swingx.decorator.LegacyHighlighter[])new java.beans.XMLDecoder(new java.io.ByteArrayInputStream(\"");
        buffer.append(this.escapeString(baos.toString()));
        buffer.append("\".getBytes())).readObject())");
        return buffer.toString();
    }

    private String escapeString(String s) {
        return s.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"").replaceAll("\n", "");
    }

    public String getDisplayName() {
        return "LegacyHighlighter Editor";
    }

    public void setAsText(String text) throws IllegalArgumentException {
    }

    public void setValue(Object value) {
        this.pipeline = value instanceof CompoundHighlighter ? new CompoundHighlighter(((CompoundHighlighter)value).getHighlighters()) : new CompoundHighlighter(new Highlighter[0]);
        super.setValue(value);
    }

    public Object getValue() {
        return this.pipeline;
    }

    public String getAsText() {
        return this.pipeline.toString();
    }

    public Component getCustomEditor() {
        return this.editor;
    }

    private class Editor
    extends JXPanel {
        private JXList highlightersList;
        private AlternateRowDetailPanel alternateRowDetailPanel = new AlternateRowDetailPanel();
        private ExpressionDetailPanel expressionDetailPanel = new ExpressionDetailPanel();
        private PatternDetailPanel patternDetailPanel = new PatternDetailPanel();

        public Editor() {
            this.setLayout(new BorderLayout());
            JSplitPane mainsp = new JSplitPane();
            mainsp.setBorder(BorderFactory.createEmptyBorder());
            JXTitledPanel tp = new JXTitledPanel("Highlighters");
            JXPanel buttonPanel = new JXPanel();
            buttonPanel.setOpaque(false);
            JButton btn = new JButton(new AddAction());
            btn.setOpaque(false);
            btn.setBorder(BorderFactory.createEmptyBorder());
            buttonPanel.add(btn);
            btn = new JButton(new DeleteAction());
            btn.setOpaque(false);
            btn.setBorder(BorderFactory.createEmptyBorder());
            buttonPanel.add(btn);
            tp.addRightDecoration(buttonPanel);
            this.highlightersList = new JXList();
            JScrollPane sp = new JScrollPane(this.highlightersList);
            sp.setBorder(BorderFactory.createEmptyBorder());
            tp.setContentContainer(sp);
            mainsp.setLeftComponent(tp);
            final JXTitledPanel details = new JXTitledPanel("LegacyHighlighter Details");
            mainsp.setRightComponent(details);
            this.add(mainsp);
            this.highlightersList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        Highlighter h = (Highlighter)Editor.this.highlightersList.getSelectedValue();
                        Container c = details.getContentContainer();
                        HighlighterDetailPanel content = null;
                        if (c instanceof HighlighterDetailPanel) {
                            content = (HighlighterDetailPanel)c;
                            content.save();
                        }
                        if (h instanceof AlternateRowHighlighter) {
                            Editor.this.alternateRowDetailPanel.init((AlternateRowHighlighter)h);
                            content = Editor.this.alternateRowDetailPanel;
                        } else if (h instanceof PatternHighlighter) {
                            Editor.this.patternDetailPanel.init((PatternHighlighter)h);
                            content = Editor.this.patternDetailPanel;
                        }
                        details.setContentContainer(content == null ? new JXPanel() : content);
                        details.revalidate();
                        details.repaint();
                    }
                }
            });
        }

        private JComboBox createColorComboBox() {
            return new JComboBox<Color>(new Color[]{Color.BLACK, Color.BLUE, Color.CYAN, Color.DARK_GRAY, Color.GRAY, Color.GREEN, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.RED, Color.WHITE, Color.YELLOW});
        }

        private class PatternDetailPanel
        extends HighlighterDetailPanel {
            private JTextField patternTF;
            private PatternHighlighter h;

            public PatternDetailPanel() {
                this.patternTF = new JTextField();
                this.add("Pattern: ", this.patternTF, true);
            }

            public void init(PatternHighlighter h) {
                super.init(h);
                this.h = h;
                this.patternTF.setText(h.getPattern().pattern());
            }

            public void save() {
                this.h.setPattern(this.patternTF.getText(), 0);
                super.save();
            }
        }

        private class ExpressionDetailPanel
        extends HighlighterDetailPanel {
            private JTextField bgExpressionTF;
            private JTextField fgExpressionTF;

            public ExpressionDetailPanel() {
                this.bgExpressionTF = new JTextField();
                this.add("Background Expression: ", this.bgExpressionTF, false);
                this.fgExpressionTF = new JTextField();
                this.add("Foreground Expression: ", this.fgExpressionTF, true);
            }

            public void init(LegacyHighlighter h) {
                super.init(h);
            }

            public void save() {
                super.save();
            }
        }

        private class AlternateRowDetailPanel
        extends HighlighterDetailPanel {
            private JComboBox evenRowCB;
            private JComboBox oddRowCB;
            private AlternateRowHighlighter h;

            public AlternateRowDetailPanel() {
                this.evenRowCB = Editor.this.createColorComboBox();
                this.add("Even Row Background: ", this.evenRowCB, false);
                this.oddRowCB = Editor.this.createColorComboBox();
                this.add("Odd Row Background: ", this.oddRowCB, true);
            }

            public void init(AlternateRowHighlighter h) {
                super.init(h);
                this.h = h;
                this.evenRowCB.setSelectedItem(h.getEvenRowBackground());
                this.oddRowCB.setSelectedItem(h.getOddRowBackground());
            }

            public void save() {
                this.h.setEvenRowBackground((Color)this.evenRowCB.getSelectedItem());
                this.h.setOddRowBackground((Color)this.oddRowCB.getSelectedItem());
                super.save();
            }
        }

        private class HighlighterDetailPanel
        extends JXPanel {
            private int rowCounter = 0;
            protected JComboBox backgroundCB;
            protected JComboBox selectedBackgroundCB;
            protected JComboBox foregroundCB;
            protected JComboBox selectedForegroundCB;
            private LegacyHighlighter h;

            public HighlighterDetailPanel() {
                this.setLayout(new GridBagLayout());
                this.backgroundCB = Editor.this.createColorComboBox();
                this.add("Background: ", this.backgroundCB, false);
                this.selectedBackgroundCB = Editor.this.createColorComboBox();
                this.add("Selected Background: ", this.selectedBackgroundCB, false);
                this.foregroundCB = Editor.this.createColorComboBox();
                this.add("Foreground: ", this.foregroundCB, false);
                this.selectedForegroundCB = Editor.this.createColorComboBox();
                this.add("Selected Foreground: ", this.selectedForegroundCB, false);
            }

            protected void add(String labelText, JComponent component, boolean isLast) {
                JLabel label = new JLabel(labelText);
                label.setLabelFor(component);
                Insets insets = this.rowCounter == 0 ? new Insets(12, 12, 5, 5) : new Insets(0, 12, 5, 5);
                this.add((Component)label, new GridBagConstraints(0, this.rowCounter, 1, 1, 0.0, 0.0, isLast ? 18 : 17, 0, insets, 0, 0));
                insets = this.rowCounter == 0 ? new Insets(12, 0, 5, 11) : new Insets(0, 0, isLast ? 11 : 5, 11);
                this.add((Component)component, new GridBagConstraints(1, this.rowCounter, 1, 1, 1.0, isLast ? 1.0 : 0.0, isLast ? 18 : 17, 2, insets, 0, 0));
                ++this.rowCounter;
            }

            protected void init(LegacyHighlighter h) {
                this.h = h;
                this.backgroundCB.setSelectedItem(h.getBackground());
                this.selectedBackgroundCB.setSelectedItem(h.getSelectedBackground());
                this.foregroundCB.setSelectedItem(h.getForeground());
                this.selectedForegroundCB.setSelectedItem(h.getSelectedForeground());
            }

            public void save() {
                this.h.setBackground((Color)this.backgroundCB.getSelectedItem());
                this.h.setSelectedBackground((Color)this.selectedBackgroundCB.getSelectedItem());
                this.h.setForeground((Color)this.foregroundCB.getSelectedItem());
                this.h.setSelectedForeground((Color)this.selectedForegroundCB.getSelectedItem());
                ListDataListener[] listeners = ((AbstractListModel)Editor.this.highlightersList.getModel()).getListDataListeners();
                int size = HighlighterPropertyEditor.this.pipeline.getHighlighters().length;
                ListDataEvent evt = new ListDataEvent(Editor.this.highlightersList, 0, size - 1, size - 1);
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].contentsChanged(evt);
                }
            }
        }

        private class AddAction
        extends AbstractAction {
            public AddAction() {
                super.putValue("SmallIcon", new ImageIcon(HighlighterPropertyEditor.class.getResource("newHighlighter.gif")));
            }

            public void actionPerformed(ActionEvent ae) {
                final JDialog dlg = new JDialog((Dialog)null, true);
                JXPanel cp = new JXPanel(new GridBagLayout());
                final JRadioButton newRB = new JRadioButton("New LegacyHighlighter");
                JRadioButton formRB = new JRadioButton("From Form");
                ButtonGroup bg = new ButtonGroup();
                bg.add(newRB);
                bg.add(formRB);
                newRB.setSelected(true);
                cp.add((Component)newRB, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(12, 12, 5, 11), 0, 0));
                JLabel label = new JLabel("Type: ");
                final JComboBox<String> typeCB = new JComboBox<String>(new String[]{"Alternate Row", "Expression", "Pattern"});
                label.setLabelFor(typeCB);
                cp.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 7, 3), 0, 0));
                cp.add(typeCB, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 7, 11), 0, 0));
                label = new JLabel("Name: ");
                JTextField nameTF = new JTextField("<auto-generate>");
                label.setLabelFor(nameTF);
                cp.add((Component)label, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 7, 3), 0, 0));
                cp.add((Component)nameTF, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 7, 11), 0, 0));
                cp.add((Component)formRB, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 12, 5, 11), 0, 0));
                label = new JLabel("Choose LegacyHighlighter: ");
                JComboBox<Object> highlighterCB = new JComboBox<Object>(new Object[0]);
                cp.add((Component)label, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 7, 3), 0, 0));
                cp.add(highlighterCB, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 17, 11), 0, 0));
                JButton okButton = new JButton(new AbstractAction("OK"){

                    public void actionPerformed(ActionEvent ae) {
                        if (newRB.isSelected()) {
                            String type = (String)typeCB.getSelectedItem();
                            LegacyHighlighter h = null;
                            if (type == null || type == "Alternate Row") {
                                h = new AlternateRowHighlighter();
                            } else if (type == "Pattern") {
                                h = new PatternHighlighter();
                            }
                            HighlighterPropertyEditor.this.pipeline.addHighlighter(h);
                            ListDataListener[] listeners = ((AbstractListModel)Editor.this.highlightersList.getModel()).getListDataListeners();
                            int size = HighlighterPropertyEditor.this.pipeline.getHighlighters().length;
                            ListDataEvent evt = new ListDataEvent(Editor.this.highlightersList, 0, size - 1, size - 1);
                            for (int i = 0; i < listeners.length; ++i) {
                                listeners[i].contentsChanged(evt);
                            }
                        }
                        dlg.setVisible(false);
                    }
                });
                JXPanel buttonPanel = new JXPanel(new GridBagLayout());
                buttonPanel.add((Component)okButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
                cp.add((Component)buttonPanel, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 12, 11, 11), 0, 0));
                dlg.setContentPane(cp);
                dlg.pack();
                dlg.setVisible(true);
            }
        }

        private class DeleteAction
        extends AbstractAction {
            public DeleteAction() {
                super.putValue("SmallIcon", new ImageIcon(HighlighterPropertyEditor.class.getResource("deleteHighlighter.gif")));
            }

            public void actionPerformed(ActionEvent ae) {
                Object[] values = Editor.this.highlightersList.getSelectedValues();
                for (int i = 0; i < values.length; ++i) {
                    HighlighterPropertyEditor.this.pipeline.removeHighlighter((LegacyHighlighter)values[i]);
                }
                ListDataListener[] listeners = ((AbstractListModel)Editor.this.highlightersList.getModel()).getListDataListeners();
                ListDataEvent evt = new ListDataEvent(Editor.this.highlightersList, 0, 0, HighlighterPropertyEditor.this.pipeline.getHighlighters().length - 1);
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].contentsChanged(evt);
                }
            }
        }
    }
}

