/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Morphing2D
implements Shape {
    private double morph;
    private Geometry startGeometry;
    private Geometry endGeometry;

    public Morphing2D(Shape startShape, Shape endShape) {
        this.startGeometry = new Geometry(startShape);
        this.endGeometry = new Geometry(endShape);
        if (this.startGeometry.getWindingRule() != this.endGeometry.getWindingRule()) {
            throw new IllegalPathStateException("shapes must use same winding rule");
        }
        double[] tvals0 = this.startGeometry.getTvals();
        double[] tvals1 = this.endGeometry.getTvals();
        double[] masterTvals = Morphing2D.mergeTvals(tvals0, tvals1);
        this.startGeometry.setTvals(masterTvals);
        this.endGeometry.setTvals(masterTvals);
    }

    public double getMorphing() {
        return this.morph;
    }

    public void setMorphing(double morph) {
        if (morph > 1.0) {
            morph = 1.0;
        } else if (!(morph >= 0.0)) {
            morph = 0.0;
        }
        this.morph = morph;
    }

    private static double interp(double v0, double v1, double t) {
        return v0 + (v1 - v0) * t;
    }

    private static double[] mergeTvals(double[] tvals0, double[] tvals1) {
        int i0 = 0;
        int i1 = 0;
        int numtvals = 0;
        while (i0 < tvals0.length && i1 < tvals1.length) {
            double t0 = tvals0[i0];
            double t1 = tvals1[i1];
            if (t0 <= t1) {
                ++i0;
            }
            if (t1 <= t0) {
                ++i1;
            }
            ++numtvals;
        }
        double[] dArray = new double[numtvals];
        i0 = 0;
        i1 = 0;
        numtvals = 0;
        while (i0 < tvals0.length && i1 < tvals1.length) {
            double d = tvals0[i0];
            double d2 = tvals1[i1];
            if (d <= d2) {
                dArray[numtvals] = d;
                ++i0;
            }
            if (d2 <= d) {
                dArray[numtvals] = d2;
                ++i1;
            }
            ++numtvals;
        }
        return dArray;
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Rectangle2D getBounds2D() {
        double xmin;
        double ymin;
        double xmax;
        double d;
        int n = this.startGeometry.getNumCoords();
        double d2 = d = Morphing2D.interp(this.startGeometry.getCoord(0), this.endGeometry.getCoord(0), this.morph);
        double ymax = xmax = Morphing2D.interp(this.startGeometry.getCoord(1), this.endGeometry.getCoord(1), this.morph);
        for (int i = 2; i < n; i += 2) {
            double x = Morphing2D.interp(this.startGeometry.getCoord(i), this.endGeometry.getCoord(i), this.morph);
            double y = Morphing2D.interp(this.startGeometry.getCoord(i + 1), this.endGeometry.getCoord(i + 1), this.morph);
            if (ymin > x) {
                ymin = x;
            }
            if (ymax > y) {
                ymax = y;
            }
            if (xmin < x) {
                xmin = x;
            }
            if (!(xmax < y)) continue;
            xmax = y;
        }
        return new Rectangle2D.Double(ymin, ymax, (double)(xmin - ymin), xmax - ymax);
    }

    public boolean contains(double x, double y) {
        throw new InternalError("unimplemented");
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean intersects(double x, double y, double w, double h) {
        throw new InternalError("unimplemented");
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(double x, double y, double w, double h) {
        throw new InternalError("unimplemented");
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new Iterator(at, this.startGeometry, this.endGeometry, this.morph);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    private static class Iterator
    implements PathIterator {
        AffineTransform at;
        Geometry g0;
        Geometry g1;
        double t;
        int cindex;
        double[] dcoords;

        public Iterator(AffineTransform at, Geometry g0, Geometry g1, double t) {
            this.at = at;
            this.g0 = g0;
            this.g1 = g1;
            this.t = t;
        }

        public int getWindingRule() {
            return this.g0.getWindingRule();
        }

        public boolean isDone() {
            return this.cindex > this.g0.getNumCoords();
        }

        public void next() {
            this.cindex = this.cindex == 0 ? 2 : (this.cindex += 6);
        }

        public int currentSegment(float[] coords) {
            int type;
            if (this.dcoords == null) {
                this.dcoords = new double[6];
            }
            if ((type = this.currentSegment(this.dcoords)) != 4) {
                coords[0] = (float)this.dcoords[0];
                coords[1] = (float)this.dcoords[1];
                if (type != 0) {
                    coords[2] = (float)this.dcoords[2];
                    coords[3] = (float)this.dcoords[3];
                    coords[4] = (float)this.dcoords[4];
                    coords[5] = (float)this.dcoords[5];
                }
            }
            return type;
        }

        public int currentSegment(double[] coords) {
            int n;
            int type;
            if (this.cindex == 0) {
                type = 0;
                n = 2;
            } else if (this.cindex >= this.g0.getNumCoords()) {
                type = 4;
                n = 0;
            } else {
                type = 3;
                n = 6;
            }
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    coords[i] = Morphing2D.interp(this.g0.getCoord(this.cindex + i), this.g1.getCoord(this.cindex + i), this.t);
                }
                if (this.at != null) {
                    this.at.transform(coords, 0, coords, 0, n / 2);
                }
            }
            return type;
        }
    }

    private static class Geometry {
        static final double THIRD = 0.3333333333333333;
        static final double MIN_LEN = 0.001;
        double[] bezierCoords = new double[20];
        int numCoords;
        int windingrule;
        double[] myTvals;

        /*
         * WARNING - void declaration
         */
        public Geometry(Shape s) {
            int n;
            double ctrlx;
            double newy;
            PathIterator pi = s.getPathIterator(null);
            this.windingrule = pi.getWindingRule();
            if (pi.isDone()) {
                this.numCoords = 8;
            }
            double[] coords = new double[6];
            int type = pi.currentSegment(coords);
            pi.next();
            if (type != 0) {
                throw new IllegalPathStateException("missing initial moveto");
            }
            double curx = this.bezierCoords[0] = coords[0];
            double cury = this.bezierCoords[1] = coords[1];
            this.numCoords = 2;
            while (!pi.isDone()) {
                if (this.numCoords + 6 > this.bezierCoords.length) {
                    int n2 = (this.numCoords - 2) * 2 + 2;
                    double[] dArray = new double[n2];
                    System.arraycopy(this.bezierCoords, 0, dArray, 0, this.numCoords);
                    this.bezierCoords = dArray;
                }
                switch (pi.currentSegment(coords)) {
                    case 0: {
                        throw new InternalError("Cannot handle multiple subpaths");
                    }
                    case 4: {
                        if (curx == this.bezierCoords[0] && cury == this.bezierCoords[1]) break;
                        coords[0] = this.bezierCoords[0];
                        coords[1] = this.bezierCoords[1];
                    }
                    case 1: {
                        double d = coords[0];
                        double newsize = coords[1];
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(curx, newy, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(cury, newsize, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(newy, curx, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(newsize, cury, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = curx = newy;
                        this.bezierCoords[this.numCoords++] = cury = newsize;
                        break;
                    }
                    case 2: {
                        void ctrly;
                        double d = coords[0];
                        double d2 = coords[1];
                        newy = coords[2];
                        ctrlx = coords[3];
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp((double)ctrly, curx, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(d2, cury, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp((double)ctrly, newy, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(d2, ctrlx, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = curx = newy;
                        this.bezierCoords[this.numCoords++] = cury = ctrlx;
                        break;
                    }
                    case 3: {
                        this.bezierCoords[this.numCoords++] = coords[0];
                        this.bezierCoords[this.numCoords++] = coords[1];
                        this.bezierCoords[this.numCoords++] = coords[2];
                        this.bezierCoords[this.numCoords++] = coords[3];
                        this.bezierCoords[this.numCoords++] = curx = coords[4];
                        this.bezierCoords[this.numCoords++] = cury = coords[5];
                    }
                }
                pi.next();
            }
            if (this.numCoords < 8 || curx != this.bezierCoords[0] || cury != this.bezierCoords[1]) {
                newy = this.bezierCoords[0];
                ctrlx = this.bezierCoords[1];
                this.bezierCoords[this.numCoords++] = Morphing2D.interp(curx, newy, 0.3333333333333333);
                this.bezierCoords[this.numCoords++] = Morphing2D.interp(cury, ctrlx, 0.3333333333333333);
                this.bezierCoords[this.numCoords++] = Morphing2D.interp(newy, curx, 0.3333333333333333);
                this.bezierCoords[this.numCoords++] = Morphing2D.interp(ctrlx, cury, 0.3333333333333333);
                this.bezierCoords[this.numCoords++] = newy;
                this.bezierCoords[this.numCoords++] = ctrlx;
            }
            int newx = 0;
            double d = this.bezierCoords[0];
            double d3 = this.bezierCoords[1];
            for (int i = 6; i < this.numCoords; i += 6) {
                double x;
                double y;
                double d4 = this.bezierCoords[i];
                double d5 = this.bezierCoords[i + 1];
                if (!(d5 < y) && (d5 != y || !(d4 < x))) continue;
                newx = i;
                x = d4;
                y = d5;
            }
            if (newx > 0) {
                double[] dArray = new double[this.numCoords];
                System.arraycopy(this.bezierCoords, newx, dArray, 0, this.numCoords - newx);
                System.arraycopy(this.bezierCoords, 2, dArray, this.numCoords - newx, newx);
                this.bezierCoords = dArray;
            }
            double d6 = 0.0;
            curx = this.bezierCoords[0];
            cury = this.bezierCoords[1];
            for (n = 2; n < this.numCoords; n += 2) {
                newy = this.bezierCoords[n];
                double minPt = this.bezierCoords[n + 1];
                d6 += curx * minPt - newy * cury;
                curx = newy;
                cury = minPt;
            }
            if (d6 < 0.0) {
                n = 2;
                for (int i = this.numCoords - 4; n < i; n += 2, i -= 2) {
                    curx = this.bezierCoords[n];
                    cury = this.bezierCoords[n + 1];
                    this.bezierCoords[n] = this.bezierCoords[i];
                    this.bezierCoords[n + 1] = this.bezierCoords[i + 1];
                    this.bezierCoords[i] = curx;
                    this.bezierCoords[i + 1] = cury;
                }
            }
        }

        public int getWindingRule() {
            return this.windingrule;
        }

        public int getNumCoords() {
            return this.numCoords;
        }

        public double getCoord(int i) {
            return this.bezierCoords[i];
        }

        public double[] getTvals() {
            if (this.myTvals != null) {
                return this.myTvals;
            }
            double[] tvals = new double[(this.numCoords - 2) / 6 + 1];
            double segx = this.bezierCoords[0];
            double segy = this.bezierCoords[1];
            double tlen = 0.0;
            int ci = 2;
            int ti = 0;
            while (ci < this.numCoords) {
                double prevx = segx;
                double prevy = segy;
                double newx = this.bezierCoords[ci++];
                double newy = this.bezierCoords[ci++];
                double len = Math.sqrt((prevx -= newx) * prevx + (prevy -= newy) * prevy);
                prevx = newx;
                prevy = newy;
                newx = this.bezierCoords[ci++];
                newy = this.bezierCoords[ci++];
                len += Math.sqrt((prevx -= newx) * prevx + (prevy -= newy) * prevy);
                prevx = newx;
                prevy = newy;
                newx = this.bezierCoords[ci++];
                newy = this.bezierCoords[ci++];
                len += Math.sqrt((prevx -= newx) * prevx + (prevy -= newy) * prevy);
                len += Math.sqrt((segx -= newx) * segx + (segy -= newy) * segy);
                if ((len /= 2.0) < 0.001) {
                    len = 0.001;
                }
                tvals[ti++] = tlen += len;
                segx = newx;
                segy = newy;
            }
            double prevt = tvals[0];
            tvals[0] = 0.0;
            for (ti = 1; ti < tvals.length - 1; ++ti) {
                double nextt = tvals[ti];
                tvals[ti] = prevt / tlen;
                prevt = nextt;
            }
            tvals[ti] = 1.0;
            this.myTvals = tvals;
            return tvals;
        }

        public void setTvals(double[] newTvals) {
            double d;
            double d2;
            double[] oldCoords = this.bezierCoords;
            double[] newCoords = new double[2 + (newTvals.length - 1) * 6];
            double[] oldTvals = this.getTvals();
            int oldci = 0;
            double d3 = d2 = oldCoords[oldci++];
            double xc1 = d2;
            double x1 = d2;
            double d4 = d = oldCoords[oldci++];
            double yc1 = d;
            double y1 = d;
            int newci = 0;
            newCoords[newci++] = x1;
            newCoords[newci++] = y1;
            double t0 = 0.0;
            double t1 = 0.0;
            int oldti = 1;
            int newti = 1;
            while (newti < newTvals.length) {
                double yc0;
                double xc0;
                double y0;
                double x0;
                if (t0 >= t1) {
                    x1 = x0;
                    y1 = y0;
                    xc1 = oldCoords[oldci++];
                    yc1 = oldCoords[oldci++];
                    xc0 = oldCoords[oldci++];
                    yc0 = oldCoords[oldci++];
                    x0 = oldCoords[oldci++];
                    y0 = oldCoords[oldci++];
                    t1 = oldTvals[oldti++];
                }
                int n = newti++;
                double nt = newTvals[n];
                if (nt < t1) {
                    double relt = (nt - t0) / (t1 - t0);
                    newCoords[newci++] = x1 = Morphing2D.interp(x1, xc1, relt);
                    newCoords[newci++] = y1 = Morphing2D.interp(y1, yc1, relt);
                    xc1 = Morphing2D.interp(xc1, xc0, relt);
                    yc1 = Morphing2D.interp(yc1, yc0, relt);
                    xc0 = Morphing2D.interp(xc0, x0, relt);
                    yc0 = Morphing2D.interp(yc0, y0, relt);
                    newCoords[newci++] = x1 = Morphing2D.interp(x1, xc1, relt);
                    newCoords[newci++] = y1 = Morphing2D.interp(y1, yc1, relt);
                    xc1 = Morphing2D.interp(xc1, xc0, relt);
                    yc1 = Morphing2D.interp(yc1, yc0, relt);
                    newCoords[newci++] = x1 = Morphing2D.interp(x1, xc1, relt);
                    newCoords[newci++] = y1 = Morphing2D.interp(y1, yc1, relt);
                } else {
                    newCoords[newci++] = xc1;
                    newCoords[newci++] = yc1;
                    newCoords[newci++] = xc0;
                    newCoords[newci++] = yc0;
                    newCoords[newci++] = x0;
                    newCoords[newci++] = y0;
                }
                t0 = nt;
            }
            this.bezierCoords = newCoords;
            this.numCoords = newCoords.length;
            this.myTvals = newTvals;
        }
    }
}

