/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.graphics;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.shiftone.jrat.depends.jdesktop.swingx.graphics.GraphicsUtilities;

public class ShadowRenderer {
    public static final String SIZE_CHANGED_PROPERTY = "shadow_size";
    public static final String OPACITY_CHANGED_PROPERTY = "shadow_opacity";
    public static final String COLOR_CHANGED_PROPERTY = "shadow_color";
    private int size = 5;
    private float opacity = 0.5f;
    private Color color = Color.BLACK;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public ShadowRenderer() {
        this(5, 0.5f, Color.BLACK);
    }

    public ShadowRenderer(int size, float opacity, Color color) {
        this.setSize(size);
        this.setOpacity(opacity);
        this.setColor(color);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color shadowColor) {
        if (shadowColor != null) {
            Color oldColor = this.color;
            this.color = shadowColor;
            this.changeSupport.firePropertyChange(COLOR_CHANGED_PROPERTY, oldColor, this.color);
        }
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float shadowOpacity) {
        float oldOpacity = this.opacity;
        this.opacity = (double)shadowOpacity < 0.0 ? 0.0f : (shadowOpacity > 1.0f ? 1.0f : shadowOpacity);
        this.changeSupport.firePropertyChange(OPACITY_CHANGED_PROPERTY, Float.valueOf(oldOpacity), Float.valueOf(this.opacity));
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int shadowSize) {
        int oldSize = this.size;
        this.size = shadowSize < 0 ? 0 : shadowSize;
        this.changeSupport.firePropertyChange(SIZE_CHANGED_PROPERTY, new Integer(oldSize), new Integer(this.size));
    }

    /*
     * WARNING - void declaration
     */
    public BufferedImage createShadow(BufferedImage image) {
        int a;
        int vSumLookup;
        int hSumLookup;
        int shadowSize = this.size * 2;
        int srcWidth = image.getWidth();
        int srcHeight = image.getHeight();
        int dstWidth = srcWidth + shadowSize;
        int dstHeight = srcHeight + shadowSize;
        int left = this.size;
        int right = shadowSize - left;
        int yStop = dstHeight - right;
        int shadowRgb = this.color.getRGB() & 0xFFFFFF;
        int[] aHistory = new int[shadowSize];
        BufferedImage bufferedImage = new BufferedImage(dstWidth, dstHeight, 2);
        int[] nArray = new int[dstWidth * dstHeight];
        int[] dst = new int[srcWidth * srcHeight];
        GraphicsUtilities.getPixels(image, 0, 0, srcWidth, srcHeight, dst);
        int dstBuffer = right * dstWidth;
        float srcBuffer = 1.0f / (float)shadowSize;
        float lastPixelOffset = this.opacity / (float)shadowSize;
        int[] hSumDivider = new int[256 * shadowSize];
        for (int vSumDivider = 0; vSumDivider < hSumDivider.length; ++vSumDivider) {
            hSumDivider[vSumDivider] = (int)((float)vSumDivider * srcBuffer);
        }
        int[] vSumDivider = new int[256 * shadowSize];
        for (hSumLookup = 0; hSumLookup < vSumDivider.length; ++hSumLookup) {
            vSumDivider[hSumLookup] = (int)((float)hSumLookup * lastPixelOffset);
        }
        int i = left * dstWidth;
        for (vSumLookup = 0; vSumLookup < srcHeight; ++vSumLookup) {
            int srcY = 0;
            while (srcY < shadowSize) {
                aHistory[srcY++] = 0;
            }
            int dstOffset = 0;
            srcY = 0;
            hSumLookup = vSumLookup * srcWidth;
            for (int srcX = 0; srcX < srcWidth; ++srcX) {
                a = hSumDivider[dstOffset];
                aSum[srcOffset++] = a << 24;
                dstOffset -= aHistory[srcY];
                aHistory[srcY] = a = dst[hSumLookup + srcX] >>> 24;
                dstOffset += a;
                if (++srcY < shadowSize) continue;
                srcY -= shadowSize;
            }
            for (int i2 = 0; i2 < shadowSize; ++i2) {
                a = hSumDivider[dstOffset];
                aSum[srcOffset++] = a << 24;
                dstOffset -= aHistory[srcY];
                if (++srcY < shadowSize) continue;
                srcY -= shadowSize;
            }
        }
        vSumLookup = 0;
        int n = 0;
        while (vSumLookup < dstWidth) {
            void aSum;
            int bufferOffset = 0;
            int x = 0;
            while (x < left) {
                aHistory[x++] = 0;
            }
            int y = 0;
            while (y < right) {
                a = aSum[n] >>> 24;
                aHistory[x++] = a;
                bufferOffset += a;
                ++y;
                n += dstWidth;
            }
            n = vSumLookup;
            x = 0;
            y = 0;
            while (y < yStop) {
                a = vSumDivider[bufferOffset];
                aSum[n] = a << 24 | shadowRgb;
                bufferOffset -= aHistory[x];
                aHistory[x] = a = aSum[n + dstBuffer] >>> 24;
                bufferOffset += a;
                if (++x >= shadowSize) {
                    x -= shadowSize;
                }
                ++y;
                n += dstWidth;
            }
            y = yStop;
            while (y < dstHeight) {
                a = vSumDivider[bufferOffset];
                aSum[n] = a << 24 | shadowRgb;
                bufferOffset -= aHistory[x];
                if (++x >= shadowSize) {
                    x -= shadowSize;
                }
                ++y;
                n += dstWidth;
            }
            n = ++vSumLookup;
        }
        GraphicsUtilities.setPixels(bufferedImage, 0, 0, dstWidth, dstHeight, nArray);
        return bufferedImage;
    }
}

