/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.image;

import java.awt.image.BufferedImage;
import org.shiftone.jrat.depends.jdesktop.swingx.graphics.GraphicsUtilities;
import org.shiftone.jrat.depends.jdesktop.swingx.image.AbstractFilter;

public class FastBlurFilter
extends AbstractFilter {
    private final int radius;

    public FastBlurFilter() {
        this(3);
    }

    public FastBlurFilter(int radius) {
        if (radius < 1) {
            radius = 1;
        }
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int[] srcPixels = new int[width * height];
        int[] dstPixels = new int[width * height];
        GraphicsUtilities.getPixels(src, 0, 0, width, height, srcPixels);
        FastBlurFilter.blur(srcPixels, dstPixels, width, height, this.radius);
        FastBlurFilter.blur(dstPixels, srcPixels, height, width, this.radius);
        GraphicsUtilities.setPixels(dst, 0, 0, width, height, srcPixels);
        return dst;
    }

    /*
     * WARNING - void declaration
     */
    static void blur(int[] srcPixels, int[] dstPixels, int width, int height, int radius) {
        int n;
        int windowSize = radius * 2 + 1;
        int radiusPlusOne = radius + 1;
        boolean bl = false;
        int[] nArray = new int[256 * windowSize];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i / windowSize;
        }
        int[] nArray2 = new int[radiusPlusOne];
        if (radius < width) {
            for (n = 0; n < nArray2.length; ++n) {
                nArray2[n] = n;
            }
        } else {
            for (n = 0; n < width; ++n) {
                nArray2[n] = n;
            }
            for (n = width; n < nArray2.length; ++n) {
                nArray2[n] = width - 1;
            }
        }
        n = 0;
        while (n < height) {
            void sumAlpha;
            void sumBlue;
            int srcIndex = 0;
            int n2 = 0;
            int n3 = 0;
            int sumLookupTable = 0;
            void indexLookupTable = sumBlue;
            int y = srcPixels[sumAlpha];
            sumLookupTable += radiusPlusOne * (y >> 24 & 0xFF);
            pixel += radiusPlusOne * (y >> 16 & 0xFF);
            dstIndex += radiusPlusOne * (y >> 8 & 0xFF);
            srcIndex += radiusPlusOne * (y & 0xFF);
            for (int i = 1; i <= radius; ++i) {
                void sumGreen;
                y = srcPixels[sumAlpha + sumGreen[i]];
                sumLookupTable += y >> 24 & 0xFF;
                pixel += y >> 16 & 0xFF;
                dstIndex += y >> 8 & 0xFF;
                srcIndex += y & 0xFF;
            }
            for (int x = 0; x < width; ++x) {
                int previousPixelIndex;
                void dstIndex;
                void pixel;
                void sumRed;
                dstPixels[indexLookupTable] = sumRed[sumLookupTable] << 24 | sumRed[pixel] << 16 | sumRed[dstIndex] << 8 | sumRed[srcIndex];
                indexLookupTable += height;
                int nextPixelIndex = x + radiusPlusOne;
                if (nextPixelIndex >= width) {
                    nextPixelIndex = width - 1;
                }
                if ((previousPixelIndex = x - radius) < 0) {
                    previousPixelIndex = 0;
                }
                int nextPixel = srcPixels[sumAlpha + nextPixelIndex];
                int previousPixel = srcPixels[sumAlpha + previousPixelIndex];
                sumLookupTable += nextPixel >> 24 & 0xFF;
                sumLookupTable -= previousPixel >> 24 & 0xFF;
                pixel += nextPixel >> 16 & 0xFF;
                pixel -= previousPixel >> 16 & 0xFF;
                dstIndex += nextPixel >> 8 & 0xFF;
                dstIndex -= previousPixel >> 8 & 0xFF;
                srcIndex += nextPixel & 0xFF;
                srcIndex -= previousPixel & 0xFF;
            }
            sumAlpha += width;
            ++sumBlue;
        }
    }
}

