/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.image;

import java.awt.image.BufferedImage;
import org.shiftone.jrat.depends.jdesktop.swingx.graphics.GraphicsUtilities;
import org.shiftone.jrat.depends.jdesktop.swingx.image.AbstractFilter;

public class GaussianBlurFilter
extends AbstractFilter {
    private final int radius;

    public GaussianBlurFilter() {
        this(3);
    }

    public GaussianBlurFilter(int radius) {
        if (radius < 1) {
            radius = 1;
        }
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int[] srcPixels = new int[width * height];
        int[] dstPixels = new int[width * height];
        float[] kernel = GaussianBlurFilter.createGaussianKernel(this.radius);
        GraphicsUtilities.getPixels(src, 0, 0, width, height, srcPixels);
        GaussianBlurFilter.blur(srcPixels, dstPixels, width, height, kernel, this.radius);
        GaussianBlurFilter.blur(dstPixels, srcPixels, height, width, kernel, this.radius);
        GraphicsUtilities.setPixels(dst, 0, 0, width, height, srcPixels);
        return dst;
    }

    /*
     * WARNING - void declaration
     */
    static void blur(int[] srcPixels, int[] dstPixels, int width, int height, float[] kernel, int radius) {
        for (int i = 0; i < height; ++i) {
            int n = i;
            int n2 = i * width;
            int n3 = 0;
            while (n3 < width) {
                void ca;
                void cr;
                void b;
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                for (int y = -radius; y <= radius; ++y) {
                    void g;
                    void index = b + y;
                    if (index < 0 || index >= width) {
                        index = (b + width) % width;
                    }
                    int offset = srcPixels[g + index];
                    float x = kernel[radius + y];
                    f4 += x * (float)(offset >> 24 & 0xFF);
                    f3 += x * (float)(offset >> 16 & 0xFF);
                    f2 += x * (float)(offset >> 8 & 0xFF);
                    f += x * (float)(offset & 0xFF);
                }
                int n4 = (int)(f4 + 0.5f);
                int n5 = (int)(f3 + 0.5f);
                int n6 = (int)(cr + 0.5f);
                int n7 = (int)(ca + 0.5f);
                dstPixels[r] = (n4 > 255 ? 255 : n4) << 24 | (n5 > 255 ? 255 : n5) << 16 | (n6 > 255 ? 255 : n6) << 8 | (n7 > 255 ? 255 : n7);
                r += height;
                ++b;
            }
        }
    }

    static float[] createGaussianKernel(int radius) {
        int i;
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        float[] data = new float[radius * 2 + 1];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        for (i = -radius; i <= radius; ++i) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        return data;
    }
}

