/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.painter;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.lang.ref.SoftReference;
import org.shiftone.jrat.depends.jdesktop.beans.AbstractBean;
import org.shiftone.jrat.depends.jdesktop.swingx.graphics.GraphicsUtilities;
import org.shiftone.jrat.depends.jdesktop.swingx.painter.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPainter<T>
extends AbstractBean
implements Painter<T> {
    private transient SoftReference<BufferedImage> cachedImage;
    private boolean cacheable = false;
    private boolean dirty = false;
    private BufferedImageOp[] filters = new BufferedImageOp[0];
    private boolean antialiasing = true;
    private Interpolation interpolation = Interpolation.NearestNeighbor;
    private boolean visible = true;

    public AbstractPainter() {
    }

    public AbstractPainter(boolean cacheable) {
        this.setCacheable(cacheable);
    }

    public final BufferedImageOp[] getFilters() {
        BufferedImageOp[] results = new BufferedImageOp[this.filters.length];
        System.arraycopy(this.filters, 0, results, 0, results.length);
        return results;
    }

    public void setFilters(BufferedImageOp ... effects) {
        if (effects == null) {
            effects = new BufferedImageOp[]{};
        }
        BufferedImageOp[] old = this.getFilters();
        this.filters = new BufferedImageOp[effects == null ? 0 : effects.length];
        System.arraycopy(effects, 0, this.filters, 0, this.filters.length);
        this.setDirty(true);
        this.firePropertyChange("filters", old, this.getFilters());
    }

    public boolean isAntialiasing() {
        return this.antialiasing;
    }

    public void setAntialiasing(boolean value) {
        boolean old = this.isAntialiasing();
        this.antialiasing = value;
        if (old != value) {
            this.setDirty(true);
        }
        this.firePropertyChange("antialiasing", old, this.isAntialiasing());
    }

    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(Interpolation value) {
        Interpolation old = this.getInterpolation();
        Interpolation interpolation = this.interpolation = value == null ? Interpolation.NearestNeighbor : value;
        if (old != value) {
            this.setDirty(true);
        }
        this.firePropertyChange("interpolation", (Object)old, (Object)this.getInterpolation());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean old = this.isVisible();
        this.visible = visible;
        if (old != visible) {
            this.setDirty(true);
        }
        this.firePropertyChange("visible", old, this.isVisible());
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        boolean old = this.isCacheable();
        this.cacheable = cacheable;
        this.firePropertyChange("cacheable", old, this.isCacheable());
        if (!this.isCacheable()) {
            this.clearCache();
        }
    }

    public void clearCache() {
        BufferedImage cache;
        BufferedImage bufferedImage = cache = this.cachedImage == null ? null : this.cachedImage.get();
        if (cache != null) {
            cache.flush();
        }
        this.cachedImage = null;
    }

    boolean isCacheCleared() {
        BufferedImage cache = this.cachedImage == null ? null : this.cachedImage.get();
        return cache == null;
    }

    protected void validate(T object) {
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean d) {
        boolean old = this.isDirty();
        this.dirty = d;
        this.firePropertyChange("dirty", old, this.isDirty());
        if (this.isDirty()) {
            this.clearCache();
        }
    }

    protected boolean shouldUseCache() {
        return this.isCacheable() || this.filters.length > 0;
    }

    protected void configureGraphics(Graphics2D g) {
        if (this.isAntialiasing()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.getInterpolation().configureGraphics(g);
    }

    protected abstract void doPaint(Graphics2D var1, T var2, int var3, int var4);

    @Override
    public final void paint(Graphics2D g, T obj, int width, int height) {
        if (g == null) {
            throw new NullPointerException("The Graphics2D must be supplied");
        }
        if (!this.isVisible() || width < 1 || height < 1) {
            return;
        }
        this.configureGraphics(g);
        if (this.shouldUseCache() || this.filters.length > 0) {
            BufferedImage cache;
            this.validate(obj);
            BufferedImage bufferedImage = cache = this.cachedImage == null ? null : this.cachedImage.get();
            if (cache == null || cache.getWidth() != width || cache.getHeight() != height || this.isDirty()) {
                cache = GraphicsUtilities.createCompatibleTranslucentImage(width, height);
                Graphics2D gfx = cache.createGraphics();
                this.configureGraphics(gfx);
                this.doPaint(gfx, obj, width, height);
                gfx.dispose();
                for (BufferedImageOp f : this.getFilters()) {
                    cache = f.filter(cache, null);
                }
                if (this.shouldUseCache()) {
                    this.cachedImage = new SoftReference<BufferedImage>(cache);
                }
            }
            g.drawImage((Image)cache, 0, 0, null);
        } else {
            this.doPaint(g, obj, width, height);
        }
        this.setDirty(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Interpolation {
        Bicubic(RenderingHints.VALUE_INTERPOLATION_BICUBIC),
        Bilinear(RenderingHints.VALUE_INTERPOLATION_BILINEAR),
        NearestNeighbor(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);

        private Object value;

        private Interpolation(Object value) {
            this.value = value;
        }

        private void configureGraphics(Graphics2D g) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.value);
        }
    }
}

