/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.painter;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import org.shiftone.jrat.depends.jdesktop.swingx.painter.CompoundPainter;
import org.shiftone.jrat.depends.jdesktop.swingx.painter.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphaPainter<T>
extends CompoundPainter<T> {
    private float alpha = 1.0f;

    @Override
    public void doPaint(Graphics2D g, T component, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.getTransform() != null) {
            g2.setTransform(this.getTransform());
        }
        if (this.alpha < 1.0f) {
            g2.setComposite(AlphaComposite.getInstance(3, this.alpha));
        }
        for (Painter p : this.getPainters()) {
            Graphics2D g3 = (Graphics2D)g2.create();
            p.paint(g3, component, width, height);
            if (this.isClipPreserved()) {
                g2.setClip(g3.getClip());
            }
            g3.dispose();
        }
        g2.dispose();
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        float old = this.getAlpha();
        this.alpha = alpha;
        this.firePropertyChange("alpha", Float.valueOf(old), Float.valueOf(this.getAlpha()));
    }
}

