/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import org.shiftone.jrat.depends.jdesktop.swingx.color.ColorUtil;
import org.shiftone.jrat.depends.jdesktop.swingx.painter.AbstractPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusyPainter<T>
extends AbstractPainter<T> {
    private int frame = -1;
    private boolean skewed = false;
    private int points = 8;
    private float barWidth = 4.0f;
    private float barLength = 8.0f;
    private float centerDistance = 5.0f;
    private Color baseColor = new Color(200, 200, 200);
    private Color highlightColor = Color.BLACK;
    private int trailLength = 4;

    @Override
    protected void doPaint(Graphics2D g, T t, int width, int height) {
        RoundRectangle2D.Float rect = new RoundRectangle2D.Float(this.getCenterDistance(), -this.getBarWidth() / 2.0f, this.getBarLength(), this.getBarWidth(), this.getBarWidth(), this.getBarWidth());
        if (this.skewed) {
            rect = new RoundRectangle2D.Float(5.0f, this.getBarWidth() / 2.0f, 8.0f, this.getBarWidth(), this.getBarWidth(), this.getBarWidth());
        }
        g.setColor(Color.GRAY);
        g.translate(width / 2, height / 2);
        for (int i = 0; i < this.getPoints(); ++i) {
            g.setColor(this.calcFrameColor(i));
            g.fill(rect);
            g.rotate(Math.PI * 2 / (double)this.getPoints());
        }
    }

    private Color calcFrameColor(int i) {
        if (this.frame == -1) {
            return this.getBaseColor();
        }
        for (int t = 0; t < this.getTrailLength(); ++t) {
            if (i != (this.frame - t + this.getPoints()) % this.getPoints()) continue;
            float terp = 1.0f - (float)(this.getTrailLength() - t) / (float)this.getTrailLength();
            return ColorUtil.interpolate(this.getBaseColor(), this.getHighlightColor(), terp);
        }
        return this.getBaseColor();
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(Color baseColor) {
        Color old = this.getBaseColor();
        this.baseColor = baseColor;
        this.setDirty(true);
        this.firePropertyChange("baseColor", old, this.getBaseColor());
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        Color old = this.getHighlightColor();
        this.highlightColor = highlightColor;
        this.setDirty(true);
        this.firePropertyChange("highlightColor", old, this.getHighlightColor());
    }

    public float getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(float barWidth) {
        float old = this.getBarWidth();
        this.barWidth = barWidth;
        this.setDirty(true);
        this.firePropertyChange("barWidth", Float.valueOf(old), Float.valueOf(this.getBarWidth()));
    }

    public float getBarLength() {
        return this.barLength;
    }

    public void setBarLength(float barLength) {
        float old = this.getBarLength();
        this.barLength = barLength;
        this.setDirty(true);
        this.firePropertyChange("barLength", Float.valueOf(old), Float.valueOf(this.getBarLength()));
    }

    public float getCenterDistance() {
        return this.centerDistance;
    }

    public void setCenterDistance(float centerDistance) {
        float old = this.getCenterDistance();
        this.centerDistance = centerDistance;
        this.setDirty(true);
        this.firePropertyChange("centerDistance", Float.valueOf(old), Float.valueOf(this.getCenterDistance()));
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int points) {
        int old = this.getPoints();
        this.points = points;
        this.setDirty(true);
        this.firePropertyChange("points", old, this.getPoints());
    }

    public int getTrailLength() {
        return this.trailLength;
    }

    public void setTrailLength(int trailLength) {
        int old = this.getTrailLength();
        this.trailLength = trailLength;
        this.setDirty(true);
        this.firePropertyChange("trailLength", old, this.getTrailLength());
    }
}

