/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.painter;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.shiftone.jrat.depends.jdesktop.swingx.painter.Painter;

public class PainterGlasspane
extends JComponent {
    private Painter painter;
    private List<JComponent> targets = new ArrayList<JComponent>();

    public void addTarget(JComponent comp) {
        this.targets.add(comp);
        this.repaint();
    }

    public void removeTarget(JComponent comp) {
        this.targets.remove(comp);
        this.repaint();
    }

    protected void paintComponent(Graphics gfx) {
        Graphics2D g = (Graphics2D)gfx;
        if (this.getPainter() != null) {
            for (JComponent target : this.targets) {
                Point offset = this.calcOffset(target);
                g.translate(offset.x, offset.y);
                this.getPainter().paint(g, target, target.getWidth(), target.getHeight());
                g.translate(-offset.x, -offset.y);
            }
        }
    }

    private Point calcOffset(JComponent target) {
        if (target == null) {
            return new Point(0, 0);
        }
        if (target.getParent() == SwingUtilities.getWindowAncestor(target)) {
            return new Point(0, 0);
        }
        Point parent = this.calcOffset((JComponent)target.getParent());
        Point self = target.getLocation();
        return new Point(parent.x + self.x, parent.y + self.y);
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
        this.repaint();
    }
}

