/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.painter;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.shiftone.jrat.depends.jdesktop.swingx.painter.AbstractAreaPainter;
import org.shiftone.jrat.depends.jdesktop.swingx.painter.effects.AreaEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextPainter<T>
extends AbstractAreaPainter<T> {
    private String text = "";
    private Font font = null;

    public TextPainter() {
        this("");
    }

    public TextPainter(String text) {
        this(text, null, null);
    }

    public TextPainter(String text, Font font) {
        this(text, font, null);
    }

    public TextPainter(String text, Paint paint) {
        this(text, null, paint);
    }

    public TextPainter(String text, Font font, Paint paint) {
        this.text = text;
        this.font = font;
        this.setFillPaint(paint);
    }

    public void setFont(Font f) {
        Font old = this.getFont();
        this.font = f;
        this.setDirty(true);
        this.firePropertyChange("font", old, this.getFont());
    }

    public Font getFont() {
        return this.font;
    }

    public void setText(String text) {
        String old = this.getText();
        this.text = text == null ? "" : text;
        this.setDirty(true);
        this.firePropertyChange("text", old, this.getText());
    }

    public String getText() {
        return this.text;
    }

    @Override
    protected void doPaint(Graphics2D g, T component, int width, int height) {
        Paint paint;
        Font font = this.calculateFont(component);
        if (font != null) {
            g.setFont(font);
        }
        if ((paint = this.getFillPaint()) == null && component instanceof JComponent) {
            paint = ((JComponent)component).getForeground();
        }
        String text = this.calculateText(component);
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        int tw = metrics.stringWidth(text);
        int th = metrics.getHeight();
        Rectangle res = this.calculateLayout(tw, th, width, height);
        g.translate(res.x, res.y);
        if (this.isPaintStretched()) {
            paint = this.calculateSnappedPaint(paint, res.width, res.height);
        }
        if (paint != null) {
            g.setPaint(paint);
        }
        g.drawString(text, 0, 0 + metrics.getAscent());
        if (this.getAreaEffects() != null) {
            Shape shape = this.provideShape(g, component, width, height);
            for (AreaEffect ef : this.getAreaEffects()) {
                ef.apply(g, shape, width, height);
            }
        }
        g.translate(-res.x, -res.y);
    }

    private String calculateText(T component) {
        String text = this.getText();
        if (text != null && !text.trim().equals("")) {
            return text;
        }
        if (component instanceof JTextComponent) {
            text = ((JTextComponent)component).getText();
        }
        if (component instanceof JLabel) {
            text = ((JLabel)component).getText();
        }
        if (component instanceof AbstractButton) {
            text = ((AbstractButton)component).getText();
        }
        return text;
    }

    private Font calculateFont(T component) {
        Font font = this.getFont();
        if (font == null && component instanceof JComponent) {
            font = ((JComponent)component).getFont();
        }
        if (font == null) {
            font = new Font("Dialog", 0, 18);
        }
        return font;
    }

    @Override
    protected Shape provideShape(Graphics2D g2, T comp, int width, int height) {
        Font font = this.calculateFont(comp);
        String text = this.calculateText(comp);
        FontMetrics metrics = g2.getFontMetrics(font);
        GlyphVector vect = font.createGlyphVector(g2.getFontRenderContext(), text);
        return vect.getOutline(0.0f, 0.0f + (float)metrics.getAscent());
    }
}

