/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.painter.effects;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.shiftone.jrat.depends.jdesktop.swingx.painter.effects.AreaEffect;

public class AbstractAreaEffect
implements AreaEffect {
    private static final boolean debug = false;
    BufferedImage _clipImage = null;
    private Color brushColor;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private int brushSteps;
    private int effectWidth;
    private boolean renderInsideShape;
    private Point2D offset;
    private boolean shouldFillShape;
    private boolean shapeMasked;

    public AbstractAreaEffect() {
        this.setBrushColor(Color.BLACK);
        this.setBrushSteps(10);
        this.setEffectWidth(8);
        this.setRenderInsideShape(false);
        this.setOffset(new Point(4, 4));
        this.setShouldFillShape(true);
        this.setShapeMasked(true);
    }

    public void apply(Graphics2D g, Shape clipShape, int width, int height) {
        width = (int)(clipShape.getBounds2D().getWidth() + clipShape.getBounds2D().getX());
        height = (int)(clipShape.getBounds2D().getHeight() + clipShape.getBounds2D().getY());
        Rectangle effectBounds = new Rectangle(0, 0, width + this.getEffectWidth() * 2 + 1, height + this.getEffectWidth() * 2 + 1);
        if (this.isShapeMasked()) {
            BufferedImage clipImage = this.getClipImage(effectBounds);
            Graphics2D g2 = clipImage.createGraphics();
            g2.setPaint(Color.BLACK);
            g2.setComposite(AlphaComposite.Clear);
            g2.fillRect(0, 0, effectBounds.width, effectBounds.height);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.translate((double)this.getEffectWidth() - this.getOffset().getX(), (double)this.getEffectWidth() - this.getOffset().getY());
            this.paintBorderGlow(g2, clipShape, width, height);
            g2.setComposite(AlphaComposite.Clear);
            g2.setColor(Color.WHITE);
            if (this.isRenderInsideShape()) {
                Area area = new Area(effectBounds);
                area.subtract(new Area(clipShape));
                g2.fill(area);
            } else {
                g2.fill(clipShape);
            }
            g2.dispose();
            g.drawImage((Image)clipImage, -this.getEffectWidth() + (int)this.getOffset().getX(), -this.getEffectWidth() + (int)this.getOffset().getY(), null);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintBorderGlow(g, clipShape, width, height);
        }
    }

    private BufferedImage getClipImage(Rectangle effectBounds) {
        if (this._clipImage == null || this._clipImage.getWidth() != effectBounds.width || this._clipImage.getHeight() != effectBounds.height) {
            this._clipImage = new BufferedImage(effectBounds.width, effectBounds.height, 2);
        }
        this._clipImage.getGraphics().clearRect(0, 0, this._clipImage.getWidth(), this._clipImage.getHeight());
        return this._clipImage;
    }

    protected void paintBorderGlow(Graphics2D g2, Shape clipShape, int width, int height) {
        int steps = this.getBrushSteps();
        float brushAlpha = 1.0f / (float)steps;
        boolean inside = this.isRenderInsideShape();
        g2.setPaint(this.getBrushColor());
        g2.translate(this.offset.getX(), this.offset.getY());
        if (this.isShouldFillShape()) {
            if (inside) {
                g2.setComposite(AlphaComposite.getInstance(10, 1.0f));
                Area a1 = new Area(new Rectangle((int)(-this.offset.getX()) - 20, (int)(-this.offset.getY()) - 20, width + 40, height + 40));
                Area a2 = new Area(clipShape);
                a1.subtract(a2);
                g2.fill(a1);
            } else {
                g2.setComposite(AlphaComposite.getInstance(4, 1.0f));
                g2.fill(clipShape);
            }
        }
        g2.setComposite(AlphaComposite.getInstance(4, brushAlpha));
        for (float i = 0.0f; i < (float)steps; i += 1.0f) {
            float brushWidth = i * (float)this.effectWidth / (float)steps;
            g2.setStroke(new BasicStroke(brushWidth, 1, 1));
            g2.draw(clipShape);
        }
        g2.translate(-this.offset.getX(), -this.offset.getY());
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public Color getBrushColor() {
        return this.brushColor;
    }

    public void setBrushColor(Color brushColor) {
        Color oldBrushColor = this.brushColor;
        this.brushColor = brushColor;
        this.propertyChangeSupport.firePropertyChange("brushColor", oldBrushColor, brushColor);
    }

    public int getBrushSteps() {
        return this.brushSteps;
    }

    public void setBrushSteps(int brushSteps) {
        int oldBrushSteps = this.brushSteps;
        this.brushSteps = brushSteps;
        this.propertyChangeSupport.firePropertyChange("brushSteps", new Integer(oldBrushSteps), new Integer(brushSteps));
    }

    public int getEffectWidth() {
        return this.effectWidth;
    }

    public void setEffectWidth(int effectWidth) {
        int oldEffectWidth = this.effectWidth;
        this.effectWidth = effectWidth;
        this.propertyChangeSupport.firePropertyChange("effectWidth", new Integer(oldEffectWidth), new Integer(effectWidth));
    }

    public boolean isRenderInsideShape() {
        return this.renderInsideShape;
    }

    public void setRenderInsideShape(boolean renderInsideShape) {
        boolean oldRenderInsideShape = this.renderInsideShape;
        this.renderInsideShape = renderInsideShape;
        this.propertyChangeSupport.firePropertyChange("renderInsideShape", new Boolean(oldRenderInsideShape), new Boolean(renderInsideShape));
    }

    public Point2D getOffset() {
        return this.offset;
    }

    public void setOffset(Point2D offset) {
        Point2D oldOffset = this.offset;
        this.offset = offset;
        this.propertyChangeSupport.firePropertyChange("offset", oldOffset, offset);
    }

    public boolean isShouldFillShape() {
        return this.shouldFillShape;
    }

    public void setShouldFillShape(boolean shouldFillShape) {
        boolean oldShouldFillShape = this.shouldFillShape;
        this.shouldFillShape = shouldFillShape;
        this.propertyChangeSupport.firePropertyChange("shouldFillShape", new Boolean(oldShouldFillShape), new Boolean(shouldFillShape));
    }

    public boolean isShapeMasked() {
        return this.shapeMasked;
    }

    public void setShapeMasked(boolean shapeMasked) {
        boolean oldShapeMasked = this.shapeMasked;
        this.shapeMasked = shapeMasked;
        this.propertyChangeSupport.firePropertyChange("shapeMasked", new Boolean(oldShapeMasked), new Boolean(shapeMasked));
    }
}

