/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.plaf;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.shiftone.jrat.depends.jdesktop.swingx.plaf.ContextMenuSource;
import org.shiftone.jrat.depends.jdesktop.swingx.plaf.TextContextMenuSource;

public class ContextMenuHandler
extends MouseAdapter {
    private ActionMap actionMap;
    private ContextMenuSource contextMenuSource;
    private JPopupMenu popup;

    public ContextMenuHandler() {
        this(null);
    }

    public ContextMenuHandler(ContextMenuSource source) {
        this.contextMenuSource = source;
    }

    public void mousePressed(MouseEvent e) {
        this.maybeShowContext(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.maybeShowContext(e);
    }

    private void maybeShowContext(final MouseEvent e) {
        if (!e.isPopupTrigger() || !e.getComponent().isEnabled()) {
            return;
        }
        if (e.getComponent().hasFocus()) {
            this.showContextPopup(e);
        } else {
            ((JComponent)e.getComponent()).grabFocus();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ContextMenuHandler.this.showContextPopup(e);
                }
            });
        }
    }

    private void showContextPopup(MouseEvent e) {
        this.showContextPopup((JComponent)e.getComponent(), e.getX(), e.getY());
    }

    private void showContextPopup(JComponent component, int x, int y) {
        JPopupMenu popup = this.getPopupMenu(component, true);
        popup.show(component, x, y);
    }

    private JPopupMenu getPopupMenu(JComponent component, boolean synchEnabled) {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            ActionMap map = this.getActionMap(component);
            String[] keys = this.getContextMenuSource().getKeys();
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i] != null) {
                    this.popup.add(map.get(keys[i]));
                    continue;
                }
                this.popup.addSeparator();
            }
        }
        if (synchEnabled) {
            this.getContextMenuSource().updateActionEnabled(component, this.actionMap);
        }
        return this.popup;
    }

    private ActionMap getActionMap(JComponent component) {
        if (this.actionMap == null) {
            this.actionMap = this.getContextMenuSource().createActionMap(component);
        }
        return this.actionMap;
    }

    private ContextMenuSource getContextMenuSource() {
        if (this.contextMenuSource == null) {
            this.contextMenuSource = new TextContextMenuSource();
        }
        return this.contextMenuSource;
    }
}

