/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.plaf;

import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;
import org.shiftone.jrat.depends.jdesktop.swingx.plaf.ContextMenuSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextContextMenuSource
extends ContextMenuSource {
    String UNDO = "Undo";
    String CUT = "Cut";
    String COPY = "Copy";
    String PASTE = "Paste";
    String DELETE = "Delete";
    String SELECT_ALL = "Select All";
    String[] keys = new String[]{"cut-to-clipboard", "copy-to-clipboard", "paste-from-clipboard", "delete-next", null, "select-all"};
    String[] defaultValues = new String[]{this.CUT, this.COPY, this.PASTE, this.DELETE, null, this.SELECT_ALL};

    @Override
    public String[] getKeys() {
        return this.keys;
    }

    @Override
    public void updateActionEnabled(JComponent component, ActionMap map) {
        if (!(component instanceof JTextComponent)) {
            return;
        }
        JTextComponent textComponent = (JTextComponent)component;
        boolean selectedText = textComponent.getSelectionEnd() - textComponent.getSelectionStart() > 0;
        boolean containsText = textComponent.getDocument().getLength() > 0;
        boolean editable = textComponent.isEditable();
        boolean copyProtected = textComponent instanceof JPasswordField;
        boolean dataOnClipboard = textComponent.getToolkit().getSystemClipboard().getContents(null) != null;
        map.get("cut-to-clipboard").setEnabled(!copyProtected && editable && selectedText);
        map.get("copy-to-clipboard").setEnabled(!copyProtected && selectedText);
        map.get("paste-from-clipboard").setEnabled(editable && dataOnClipboard);
        map.get("delete-next").setEnabled(editable && selectedText);
        map.get("select-all").setEnabled(containsText);
    }

    @Override
    protected void initNames(Map<String, String> names) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            names.put(this.keys[i], this.getValue(this.keys[i], this.defaultValues[i]));
        }
    }

    @Override
    protected String getResourcePrefix() {
        return "DefaultEditorKit.";
    }
}

