/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.SortedSet;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.shiftone.jrat.depends.jdesktop.swingx.DateSelectionListener;
import org.shiftone.jrat.depends.jdesktop.swingx.DateSelectionModel;
import org.shiftone.jrat.depends.jdesktop.swingx.calendar.DateUtils;
import org.shiftone.jrat.depends.jdesktop.swingx.calendar.JXMonthView;
import org.shiftone.jrat.depends.jdesktop.swingx.event.DateSelectionEvent;
import org.shiftone.jrat.depends.jdesktop.swingx.plaf.MonthViewUI;

public class BasicMonthViewUI
extends MonthViewUI {
    private static final Logger LOG = Logger.getLogger(BasicMonthViewUI.class.getName());
    protected static final int LEADING_DAY_OFFSET = 1;
    protected static final int NO_OFFSET = 0;
    protected static final int TRAILING_DAY_OFFSET = -1;
    private static final int WEEKS_IN_MONTH = 6;
    private static final int CALENDAR_SPACING = 10;
    private static final Point NO_SUCH_CALENDAR = new Point(-1, -1);
    protected static final SimpleDateFormat dayOfMonthFormatter = new SimpleDateFormat("d");
    private static String[] monthsOfTheYear;
    protected JXMonthView monthView;
    protected long firstDisplayedDate;
    protected int firstDisplayedMonth;
    protected int firstDisplayedYear;
    protected long lastDisplayedDate;
    protected long today;
    protected SortedSet<Date> selection;
    protected Font derivedFont;
    private boolean usingKeyboard = false;
    private long pivotDate = -1L;
    protected boolean isLeftToRight;
    private int arrowPaddingX = 3;
    private int arrowPaddingY = 3;
    private int fullMonthBoxHeight;
    private int fullBoxWidth;
    private int fullBoxHeight;
    private int startX;
    private int startY;
    private Dimension dim = new Dimension();
    private PropertyChangeListener propertyChangeListener;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private Handler handler;
    protected Icon monthUpImage;
    protected Icon monthDownImage;
    private Rectangle dirtyRect = new Rectangle();
    private Rectangle bounds = new Rectangle();
    private Color weekOfTheYearForeground;
    private Color unselectableDayForeground;
    private Color leadingDayForeground;
    private Color trailingDayForeground;
    private SortedSet<Date> originalDateSpan;
    private int calendarWidth;
    private int monthBoxHeight;
    private int boxWidth;
    private int boxHeight;
    private int calendarHeight;
    private int numCalRows = 1;
    private int numCalCols = 1;
    private Rectangle[] monthStringBounds = new Rectangle[12];
    private Rectangle[] yearStringBounds = new Rectangle[12];

    public static ComponentUI createUI(JComponent c) {
        return new BasicMonthViewUI();
    }

    public void installUI(JComponent c) {
        this.monthView = (JXMonthView)c;
        this.monthView.setLayout(this.createLayoutManager());
        this.isLeftToRight = this.monthView.getComponentOrientation().isLeftToRight();
        LookAndFeel.installProperty(this.monthView, "opaque", Boolean.TRUE);
        monthsOfTheYear = new DateFormatSymbols().getMonths();
        this.installComponents();
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
        if (this.monthView.getCalendar() != null) {
            this.firstDisplayedDate = this.monthView.getCalendar().getTimeInMillis();
            this.firstDisplayedMonth = this.monthView.getCalendar().get(2);
            this.firstDisplayedYear = this.monthView.getCalendar().get(1);
        }
        this.selection = this.monthView.getSelection();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.monthView.setLayout(null);
        this.monthView = null;
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installDefaults() {
        Color background;
        String[] daysOfTheWeek = (String[])UIManager.get("JXMonthView.daysOfTheWeek");
        if (daysOfTheWeek == null) {
            String[] dateFormatSymbols = new DateFormatSymbols().getShortWeekdays();
            daysOfTheWeek = new String[7];
            for (int i = 1; i <= 7; ++i) {
                daysOfTheWeek[i - 1] = dateFormatSymbols[i];
            }
        }
        if ((background = this.monthView.getBackground()) == null || background instanceof UIResource) {
            this.monthView.setBackground(UIManager.getColor("JXMonthView.background"));
        }
        this.monthView.setDaysOfTheWeek(daysOfTheWeek);
        this.monthView.setBoxPaddingX((Integer)UIManager.get("JXMonthView.boxPaddingX"));
        this.monthView.setBoxPaddingY((Integer)UIManager.get("JXMonthView.boxPaddingY"));
        this.monthView.setMonthStringBackground(UIManager.getColor("JXMonthView.monthStringBackground"));
        this.monthView.setMonthStringForeground(UIManager.getColor("JXMonthView.monthStringForeground"));
        this.monthView.setDaysOfTheWeekForeground(UIManager.getColor("JXMonthView.daysOfTheWeekForeground"));
        this.monthView.setSelectedBackground(UIManager.getColor("JXMonthView.selectedBackground"));
        this.monthView.setFlaggedDayForeground(UIManager.getColor("JXMonthView.flaggedDayForeground"));
        Font f = this.monthView.getFont();
        if (f == null || f instanceof UIResource) {
            this.monthView.setFont(UIManager.getFont("JXMonthView.font"));
        }
        this.monthDownImage = new ImageIcon(JXMonthView.class.getResource(UIManager.getString("JXMonthView.monthDownFileName")));
        this.monthUpImage = new ImageIcon(JXMonthView.class.getResource(UIManager.getString("JXMonthView.monthUpFileName")));
        this.weekOfTheYearForeground = UIManager.getColor("JXMonthView.weekOfTheYearForeground");
        this.leadingDayForeground = UIManager.getColor("JXMonthView.leadingDayForeground");
        this.trailingDayForeground = UIManager.getColor("JXMonthView.trailingDayForeground");
        this.unselectableDayForeground = UIManager.getColor("JXMonthView.unselectableDayForeground");
        this.derivedFont = this.createDerivedFont();
    }

    protected void uninstallDefaults() {
    }

    protected void installKeyboardActions() {
        this.installKeyBindings(0);
        ActionMap actionMap = this.monthView.getActionMap();
        KeyboardAction acceptAction = new KeyboardAction(0);
        actionMap.put("acceptSelection", acceptAction);
        KeyboardAction cancelAction = new KeyboardAction(1);
        actionMap.put("cancelSelection", cancelAction);
        actionMap.put("selectPreviousDay", new KeyboardAction(2));
        actionMap.put("selectNextDay", new KeyboardAction(3));
        actionMap.put("selectDayInPreviousWeek", new KeyboardAction(4));
        actionMap.put("selectDayInNextWeek", new KeyboardAction(5));
        actionMap.put("adjustSelectionPreviousDay", new KeyboardAction(6));
        actionMap.put("adjustSelectionNextDay", new KeyboardAction(7));
        actionMap.put("adjustSelectionPreviousWeek", new KeyboardAction(8));
        actionMap.put("adjustSelectionNextWeek", new KeyboardAction(9));
        actionMap.put("monthViewCommit", acceptAction);
        actionMap.put("monthViewCancel", cancelAction);
    }

    private void installKeyBindings(int type) {
        InputMap inputMap = this.monthView.getInputMap(type);
        inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "acceptSelection");
        inputMap.put(KeyStroke.getKeyStroke(27, 0, false), "cancelSelection");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "selectPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "selectNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "selectDayInPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "selectDayInNextWeek");
        inputMap.put(KeyStroke.getKeyStroke(37, 1, false), "adjustSelectionPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 1, false), "adjustSelectionNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 1, false), "adjustSelectionPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 1, false), "adjustSelectionNextWeek");
    }

    private void uninstallKeyBindings(int type) {
        InputMap inputMap = this.monthView.getInputMap(type);
        inputMap.clear();
    }

    protected void uninstallKeyboardActions() {
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.mouseListener = this.createMouseListener();
        this.mouseMotionListener = this.createMouseMotionListener();
        this.monthView.addPropertyChangeListener(this.propertyChangeListener);
        this.monthView.addMouseListener(this.mouseListener);
        this.monthView.addMouseMotionListener(this.mouseMotionListener);
        this.monthView.getSelectionModel().addDateSelectionListener(this.getHandler());
    }

    protected void uninstallListeners() {
        this.monthView.getSelectionModel().removeDateSelectionListener(this.getHandler());
        this.monthView.removeMouseMotionListener(this.mouseMotionListener);
        this.monthView.removeMouseListener(this.mouseListener);
        this.monthView.removePropertyChangeListener(this.propertyChangeListener);
        this.mouseMotionListener = null;
        this.mouseListener = null;
        this.propertyChangeListener = null;
    }

    protected void updateComponentInputMap() {
        if (this.monthView.isComponentInputMapEnabled()) {
            this.installKeyBindings(2);
        } else {
            this.uninstallKeyBindings(2);
        }
    }

    protected Font createDerivedFont() {
        return this.monthView.getFont().deriveFont(1);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected LayoutManager createLayoutManager() {
        return this.getHandler();
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    public boolean isUsingKeyboard() {
        return this.usingKeyboard;
    }

    public void setUsingKeyboard(boolean val) {
        this.usingKeyboard = val;
    }

    protected boolean isToday(long date) {
        return date == this.today;
    }

    public long getDayAt(int x, int y) {
        Point rowCol = this.getCalRowColAt(x, y);
        if (NO_SUCH_CALENDAR.equals(rowCol)) {
            return -1L;
        }
        if (rowCol.x > this.numCalRows - 1 || rowCol.y > this.numCalCols - 1) {
            return -1L;
        }
        int row = 1;
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        row += (y - this.startY - rowCol.x * (this.calendarHeight + 10) - (boxPaddingY + this.monthBoxHeight + boxPaddingY)) / (boxPaddingY + this.boxHeight + boxPaddingY);
        if ((row -= 2) < 0 || row > 5) {
            return -1L;
        }
        int col = ((this.isLeftToRight ? x - this.startX : this.startX - x) - rowCol.y * (this.calendarWidth + 10)) / (boxPaddingX + this.boxWidth + boxPaddingX);
        if (this.monthView.isShowingWeekNumber()) {
            --col;
        }
        if (col < 0 || col > 6) {
            return -1L;
        }
        Calendar cal = this.monthView.getCalendar();
        cal.setTimeInMillis(this.firstDisplayedDate);
        cal.add(2, rowCol.y + rowCol.x * this.numCalCols);
        int firstDayViewIndex = this.getDayOfWeekViewIndex(cal.get(7));
        int daysToAdd = row * 7 + (col - firstDayViewIndex);
        if (daysToAdd < 0 || daysToAdd > cal.getActualMaximum(5) - 1) {
            return -1L;
        }
        cal.add(5, daysToAdd);
        long selected = cal.getTimeInMillis();
        cal.setTimeInMillis(this.firstDisplayedDate);
        return selected;
    }

    protected int getDayOfTheWeek() {
        return this.monthView.getCalendar().get(7);
    }

    private int getDayOfWeekViewIndex(int dayOfWeek) {
        int result = dayOfWeek - this.monthView.getFirstDayOfWeek();
        if (result < 0) {
            result += 7;
        }
        return result;
    }

    protected int getTraversableButtonAt(int x, int y) {
        Point rowCol = this.getCalRowColAt(x, y);
        if (NO_SUCH_CALENDAR.equals(rowCol)) {
            return -1;
        }
        if ((y = y - this.startY - rowCol.x * (this.calendarHeight + 10) - this.monthView.getBoxPaddingY()) < this.arrowPaddingY || y > this.monthBoxHeight - this.arrowPaddingY) {
            return -1;
        }
        x = (this.isLeftToRight ? x - this.startX : this.startX - x) - rowCol.y * (this.calendarWidth + 10);
        if (x > this.arrowPaddingX && x < this.arrowPaddingX + this.monthDownImage.getIconWidth() + this.arrowPaddingX) {
            return 1;
        }
        if (x > this.calendarWidth - this.arrowPaddingX * 2 - this.monthUpImage.getIconWidth() && x < this.calendarWidth - this.arrowPaddingX) {
            return 2;
        }
        return -1;
    }

    protected Point getCalRowColAt(int x, int y) {
        if (this.isLeftToRight ? this.startX > x : this.startX < x || this.startY > y) {
            return NO_SUCH_CALENDAR;
        }
        Point result = new Point();
        result.x = (y - this.startY) / (this.calendarHeight + 10);
        result.y = (this.isLeftToRight ? x - this.startX : this.startX - x) / (this.calendarWidth + 10);
        if (result.x > this.numCalRows - 1 || result.y > this.numCalCols - 1) {
            result = NO_SUCH_CALENDAR;
        }
        return result;
    }

    private void calculateStartPosition() {
        int width = this.monthView.getWidth();
        this.startX = (width - (this.calendarWidth * this.numCalCols + 10 * (this.numCalCols - 1))) / 2;
        if (!this.isLeftToRight) {
            this.startX = width - this.startX;
        }
        this.startY = (this.monthView.getHeight() - (this.calendarHeight * this.numCalRows + 10 * (this.numCalRows - 1))) / 2;
    }

    private void calculateNumDisplayedCals() {
        int oldNumCalCols = this.numCalCols;
        int oldNumCalRows = this.numCalRows;
        this.numCalCols = 1;
        this.numCalCols += (this.monthView.getWidth() - this.calendarWidth) / (this.calendarWidth + 10);
        this.numCalRows = 1;
        this.numCalRows += (this.monthView.getHeight() - this.calendarHeight) / (this.calendarHeight + 10);
        if (oldNumCalCols != this.numCalCols || oldNumCalRows != this.numCalRows) {
            this.calculateLastDisplayedDate();
        }
    }

    public long calculateLastDisplayedDate() {
        Calendar cal = this.monthView.getCalendar();
        cal.setTimeInMillis(this.firstDisplayedDate);
        cal.add(2, this.numCalCols * this.numCalRows - 1);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        this.lastDisplayedDate = cal.getTimeInMillis();
        return this.lastDisplayedDate;
    }

    private void calculateDirtyRectForSelection() {
        if (this.selection == null || this.selection.isEmpty()) {
            this.dirtyRect.x = 0;
            this.dirtyRect.y = 0;
            this.dirtyRect.width = 0;
            this.dirtyRect.height = 0;
        } else {
            Calendar cal = this.monthView.getCalendar();
            cal.setTime(this.selection.first());
            this.calculateBoundsForDay(this.dirtyRect, 0);
            cal.add(5, 1);
            while (cal.getTimeInMillis() <= this.selection.last().getTime()) {
                this.calculateBoundsForDay(this.bounds, 0);
                Rectangle tmpRect = this.dirtyRect.union(this.bounds);
                this.dirtyRect.x = tmpRect.x;
                this.dirtyRect.y = tmpRect.y;
                this.dirtyRect.width = tmpRect.width;
                this.dirtyRect.height = tmpRect.height;
                cal.add(5, 1);
            }
            cal.setTimeInMillis(this.firstDisplayedDate);
        }
    }

    protected void calculateBoundsForDay(Rectangle bounds, int monthOffset) {
        Calendar cal = this.monthView.getCalendar();
        int year = cal.get(1);
        int month = cal.get(2);
        int weekOfMonth = cal.get(4);
        month += monthOffset;
        if (1 == monthOffset) {
            weekOfMonth = 1;
        }
        if (-1 == monthOffset) {
            int day = cal.get(5);
            int weekOffset = cal.get(4) - 1;
            cal.add(5, -day);
            int lastWeekOfMonth = cal.get(4);
            int lastDay = this.getDayOfWeekViewIndex(cal.get(7));
            if (lastDay == 6) {
                ++weekOffset;
            }
            cal.add(5, day);
            weekOfMonth = lastWeekOfMonth + weekOffset;
        }
        int diffMonths = month - this.firstDisplayedMonth + (year - this.firstDisplayedYear) * 12;
        int calRowIndex = diffMonths / this.numCalCols;
        int calColIndex = diffMonths - calRowIndex * this.numCalCols;
        bounds.x = this.getDayOfWeekViewIndex(cal.get(7));
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        if (this.monthView.isShowingWeekNumber()) {
            ++bounds.x;
        }
        bounds.x = this.isLeftToRight ? bounds.x * (boxPaddingX + this.boxWidth + boxPaddingX) : (bounds.x + 1) * (boxPaddingX + this.boxWidth + boxPaddingX);
        bounds.x += calColIndex * (this.calendarWidth + 10);
        bounds.x = this.isLeftToRight ? this.startX + bounds.x : this.startX - bounds.x;
        bounds.y = boxPaddingY + this.monthBoxHeight + boxPaddingY + boxPaddingY + this.boxHeight + boxPaddingY;
        bounds.y += this.startY + calRowIndex * (this.calendarHeight + 10);
        bounds.y += (weekOfMonth - 1) * (boxPaddingY + this.boxHeight + boxPaddingY);
        bounds.width = boxPaddingX + this.boxWidth + boxPaddingX;
        bounds.height = boxPaddingY + this.boxHeight + boxPaddingY;
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D g2;
        super.paint(g, c);
        Object oldAAValue = null;
        Graphics2D graphics2D = g2 = g instanceof Graphics2D ? (Graphics2D)g : null;
        if (g2 != null && this.monthView.isAntialiased()) {
            oldAAValue = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Rectangle clip = g.getClipBounds();
        Graphics tmp = g.create();
        this.paintBackground(clip, tmp);
        tmp.dispose();
        g.setColor(this.monthView.getForeground());
        Calendar cal = this.monthView.getCalendar();
        cal.setTimeInMillis(this.firstDisplayedDate);
        for (int row = 0; row < this.numCalRows; ++row) {
            this.bounds.x = 0;
            this.bounds.y = this.startY + row * (this.calendarHeight + 10);
            this.bounds.width = this.monthView.getWidth();
            this.bounds.height = this.calendarHeight;
            if (!this.bounds.intersects(clip)) {
                cal.add(2, this.numCalCols);
                continue;
            }
            for (int column = 0; column < this.numCalCols; ++column) {
                this.bounds.x = this.startX + (this.isLeftToRight ? column * (this.calendarWidth + 10) : -(column * (this.calendarWidth + 10) + this.calendarWidth));
                this.bounds.y = this.startY + row * (this.calendarHeight + 10);
                this.bounds.width = this.calendarWidth;
                this.bounds.height = this.calendarHeight;
                if (this.bounds.intersects(clip)) {
                    this.paintMonth(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                    continue;
                }
                cal.add(2, 1);
            }
        }
        cal.setTimeInMillis(this.firstDisplayedDate);
        if (g2 != null && this.monthView.isAntialiased()) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        }
    }

    private void paintMonth(Graphics g, int x, int y, int width, int height) {
        long oldY;
        int daysOfTheWeek;
        int fm;
        Calendar cal = this.monthView.getCalendar();
        int days = cal.getActualMaximum(5);
        Rectangle clip = g.getClipBounds();
        int n = -1;
        int n2 = this.monthView.getBoxPaddingX();
        int oldWeek = this.monthView.getBoxPaddingY();
        this.paintMonthStringBackground(g, x, y, width, oldWeek + this.monthBoxHeight + oldWeek);
        this.paintMonthStringForeground(g, x, y, width, oldWeek + this.monthBoxHeight + oldWeek);
        if (this.monthView.isTraversable()) {
            this.monthDownImage.paintIcon(this.monthView, g, x + this.arrowPaddingX, y + (this.fullMonthBoxHeight - this.monthDownImage.getIconHeight()) / 2);
            this.monthUpImage.paintIcon(this.monthView, g, x + width - this.arrowPaddingX - this.monthUpImage.getIconWidth(), y + (this.fullMonthBoxHeight - this.monthDownImage.getIconHeight()) / 2);
        }
        boolean boxPaddingX = this.monthView.isShowingWeekNumber();
        int boxPaddingY = this.isLeftToRight ? x + (boxPaddingX ? this.fullBoxWidth : 0) : x;
        int showingWeekNumber = y + this.fullMonthBoxHeight;
        int tmpX = width - (boxPaddingX ? this.fullBoxWidth : 0);
        this.paintDayOfTheWeekBackground(g, boxPaddingY, showingWeekNumber, tmpX, this.fullBoxHeight);
        int tmpY = this.monthView.getFirstDayOfWeek() - 1;
        Font tmpWidth = this.monthView.getFont();
        g.setFont(this.derivedFont);
        g.setColor(this.monthView.getDaysOfTheWeekForeground());
        FontMetrics dayIndex = this.monthView.getFontMetrics(this.derivedFont);
        String[] oldFont = this.monthView.getDaysOfTheWeek();
        for (fm = 0; fm < 7; ++fm) {
            int n3 = boxPaddingY = this.isLeftToRight ? x + fm * this.fullBoxWidth + n2 + this.boxWidth / 2 - dayIndex.stringWidth(oldFont[tmpY]) / 2 : x + width - fm * this.fullBoxWidth - n2 - this.boxWidth / 2 - dayIndex.stringWidth(oldFont[tmpY]) / 2;
            if (boxPaddingX) {
                boxPaddingY += this.isLeftToRight ? this.fullBoxWidth : -this.fullBoxWidth;
            }
            showingWeekNumber = y + this.fullMonthBoxHeight + oldWeek + dayIndex.getAscent();
            g.drawString(oldFont[tmpY], boxPaddingY, showingWeekNumber);
            if (++tmpY != 7) continue;
            tmpY = 0;
        }
        g.setFont(tmpWidth);
        if (boxPaddingX) {
            boxPaddingY = this.isLeftToRight ? x : x + width - this.fullBoxWidth;
            this.paintWeekOfYearBackground(g, boxPaddingY, y + this.fullMonthBoxHeight + this.fullBoxHeight, this.fullBoxWidth, this.calendarHeight - (this.fullMonthBoxHeight + this.fullBoxHeight));
        }
        if (this.monthView.isShowingLeadingDates() && (fm = this.getDayOfWeekViewIndex(cal.get(7))) != 0) {
            cal.add(5, -fm);
            for (daysOfTheWeek = 0; daysOfTheWeek < fm; ++daysOfTheWeek) {
                this.calculateBoundsForDay(this.bounds, 1);
                long dayOfWeekViewIndex = cal.getTimeInMillis();
                this.paintLeadingDayBackground(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, dayOfWeekViewIndex);
                this.paintLeadingDayForeground(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, dayOfWeekViewIndex);
                cal.add(5, 1);
            }
        }
        fm = -1;
        for (daysOfTheWeek = 0; daysOfTheWeek < days; ++daysOfTheWeek) {
            this.calculateBoundsForDay(this.bounds, 0);
            if (boxPaddingX && fm != this.bounds.y) {
                int day;
                fm = this.bounds.y;
                int weekOfYear = cal.get(3);
                if (weekOfYear != day) {
                    boxPaddingY = this.isLeftToRight ? x : x + width - this.fullBoxWidth;
                    this.paintWeekOfYearForeground(g, boxPaddingY, this.bounds.y, this.fullBoxWidth, this.fullBoxHeight, weekOfYear);
                    day = weekOfYear;
                }
            }
            if (this.bounds.intersects(clip)) {
                oldY = cal.getTimeInMillis();
                if (this.monthView.isSelectedDate(oldY) && this.monthView.getSelectionMode() == JXMonthView.SelectionMode.SINGLE_SELECTION) {
                    this.dirtyRect.x = this.bounds.x;
                    this.dirtyRect.y = this.bounds.y;
                    this.dirtyRect.width = this.bounds.width;
                    this.dirtyRect.height = this.bounds.height;
                }
                if (this.monthView.isUnselectableDate(oldY)) {
                    this.paintUnselectableDayBackground(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, oldY);
                    this.paintUnselectableDayForeground(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, oldY);
                } else if (this.monthView.isFlaggedDate(oldY)) {
                    this.paintFlaggedDayBackground(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, oldY);
                    this.paintFlaggedDayForeground(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, oldY);
                } else {
                    this.paintDayBackground(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, oldY);
                    this.paintDayForeground(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, oldY);
                }
            }
            cal.add(5, 1);
        }
        if (this.monthView.isShowingTrailingDates()) {
            cal.add(5, -1);
            daysOfTheWeek = cal.get(4);
            if (6 == this.getDayOfWeekViewIndex(cal.get(7))) {
                ++daysOfTheWeek;
            }
            cal.add(5, 1);
            int daysToPaint = 7 * (6 - daysOfTheWeek);
            if ((daysToPaint += 7 - this.getDayOfWeekViewIndex(cal.get(7))) != 0) {
                for (int i = 0; i < daysToPaint; ++i) {
                    this.calculateBoundsForDay(this.bounds, -1);
                    oldY = cal.getTimeInMillis();
                    this.paintTrailingDayBackground(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, oldY);
                    this.paintTrailingDayForeground(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, oldY);
                    cal.add(5, 1);
                }
            }
            cal.set(5, 1);
        }
    }

    protected void paintDayOfTheWeekBackground(Graphics g, int x, int y, int width, int height) {
        int boxPaddingX = this.monthView.getBoxPaddingX();
        g.drawLine(x + boxPaddingX, y + height - 1, x + width - boxPaddingX, y + height - 1);
    }

    protected void paintWeekOfYearBackground(Graphics g, int x, int y, int width, int height) {
        int boxPaddingY = this.monthView.getBoxPaddingY();
        x = this.isLeftToRight ? x + width - 1 : x;
        g.drawLine(x, y + boxPaddingY, x, y + height - boxPaddingY);
    }

    /*
     * WARNING - void declaration
     */
    protected void paintWeekOfYearForeground(Graphics g, int x, int y, int width, int height, int weekOfYear) {
        void fm;
        String str = Integer.toString(weekOfYear);
        g.setColor(this.weekOfTheYearForeground);
        int n = this.monthView.getBoxPaddingX();
        int boxPaddingX = this.monthView.getBoxPaddingY();
        FontMetrics boxPaddingY = g.getFontMetrics();
        g.drawString(str, this.isLeftToRight ? x + fm + this.boxWidth - boxPaddingY.stringWidth(str) : x + fm + this.boxWidth - boxPaddingY.stringWidth(str) - 1, y + boxPaddingX + boxPaddingY.getAscent());
    }

    protected void paintMonthStringBackground(Graphics g, int x, int y, int width, int height) {
        Insets monthStringInsets = this.monthView.getMonthStringInsets();
        x = this.isLeftToRight ? x + monthStringInsets.left : x + monthStringInsets.right;
        width = width - monthStringInsets.left - monthStringInsets.right;
        height = height - monthStringInsets.top - monthStringInsets.bottom;
        g.setColor(this.monthView.getMonthStringBackground());
        g.fillRect(x, y += monthStringInsets.top, width, height);
    }

    protected void paintMonthStringForeground(Graphics g, int x, int y, int width, int height) {
        Calendar cal = this.monthView.getCalendar();
        Font oldFont = this.monthView.getFont();
        g.setFont(this.derivedFont);
        FontMetrics fm = this.monthView.getFontMetrics(this.derivedFont);
        int month = cal.get(2);
        String monthName = monthsOfTheYear[month];
        String yearString = Integer.toString(cal.get(1));
        Rectangle2D rect = fm.getStringBounds(monthName, g);
        this.monthStringBounds[month] = new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
        int spaceWidth = (int)fm.getStringBounds(" ", g).getWidth();
        rect = fm.getStringBounds(yearString, g);
        this.yearStringBounds[month] = new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
        g.setColor(this.monthView.getMonthStringForeground());
        int tmpX = x + this.calendarWidth / 2 - (this.monthStringBounds[month].width + this.yearStringBounds[month].width + spaceWidth) / 2;
        int tmpY = y + this.monthView.getBoxPaddingY() + (this.monthBoxHeight - this.boxHeight) / 2 + fm.getAscent();
        this.monthStringBounds[month].x = tmpX;
        this.yearStringBounds[month].x = this.monthStringBounds[month].x + this.monthStringBounds[month].width + spaceWidth;
        this.paintMonthStringForeground(g, monthName, this.monthStringBounds[month].x, tmpY, yearString, this.yearStringBounds[month].x, tmpY);
        g.setFont(oldFont);
    }

    protected void paintMonthStringForeground(Graphics g, String monthName, int monthX, int monthY, String yearName, int yearX, int yearY) {
        g.drawString(monthName, monthX, monthY);
        g.drawString(yearName, yearX, yearY);
    }

    protected void paintDayBackground(Graphics g, int x, int y, int width, int height, long date) {
        if (this.monthView.isSelectedDate(date)) {
            g.setColor(this.monthView.getSelectedBackground());
            g.fillRect(x, y, width, height);
        }
        if (this.isToday(date)) {
            g.setColor(this.monthView.getTodayBackground());
            g.drawRect(x, y, width - 1, height - 1);
        }
    }

    protected void paintDayForeground(Graphics g, int x, int y, int width, int height, long date) {
        String numericDay = dayOfMonthFormatter.format(date);
        g.setColor(this.monthView.getDayForeground(this.getDayOfTheWeek()));
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        this.paintDayForeground(g, numericDay, this.isLeftToRight ? x + boxPaddingX + this.boxWidth : x + boxPaddingX + this.boxWidth - 1, y + boxPaddingY);
    }

    protected void paintDayForeground(Graphics g, String numericDay, int x, int y) {
        FontMetrics fm = g.getFontMetrics();
        g.drawString(numericDay, x - fm.stringWidth(numericDay), y + fm.getAscent());
    }

    protected void paintFlaggedDayBackground(Graphics g, int x, int y, int width, int height, long date) {
        this.paintDayBackground(g, x, y, width, height, date);
    }

    /*
     * WARNING - void declaration
     */
    protected void paintFlaggedDayForeground(Graphics g, int x, int y, int width, int height, long date) {
        void fm;
        String numericDay = dayOfMonthFormatter.format(date);
        int n = this.monthView.getBoxPaddingX();
        int boxPaddingX = this.monthView.getBoxPaddingY();
        Font boxPaddingY = this.monthView.getFont();
        g.setColor(this.monthView.getFlaggedDayForeground());
        g.setFont(this.derivedFont);
        FontMetrics oldFont = this.monthView.getFontMetrics(this.derivedFont);
        g.drawString(numericDay, this.isLeftToRight ? x + fm + this.boxWidth - oldFont.stringWidth(numericDay) : x + fm + this.boxWidth - oldFont.stringWidth(numericDay) - 1, y + boxPaddingX + oldFont.getAscent());
        g.setFont(boxPaddingY);
    }

    protected void paintUnselectableDayBackground(Graphics g, int x, int y, int width, int height, long date) {
        this.paintDayBackground(g, x, y, width, height, date);
    }

    protected void paintUnselectableDayForeground(Graphics g, int x, int y, int width, int height, long date) {
        this.paintDayForeground(g, x, y, width, height, date);
        g.setColor(this.unselectableDayForeground);
        String numericDay = dayOfMonthFormatter.format(date);
        FontMetrics fm = this.monthView.getFontMetrics(this.derivedFont);
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        width = fm.stringWidth(numericDay);
        height = fm.getAscent();
        x = this.isLeftToRight ? x + boxPaddingX + this.boxWidth - fm.stringWidth(numericDay) : x + boxPaddingX + this.boxWidth - fm.stringWidth(numericDay) - 1;
        g.drawLine(x, y += boxPaddingY, x + width, y + height);
        g.drawLine(x + 1, y, x + width + 1, y + height);
        g.drawLine(x + width, y, x, y + height);
        g.drawLine(x + width - 1, y, x - 1, y + height);
    }

    protected void paintLeadingDayBackground(Graphics g, int x, int y, int width, int height, long date) {
        this.paintDayBackground(g, x, y, width, height, date);
    }

    /*
     * WARNING - void declaration
     */
    protected void paintLeadingDayForeground(Graphics g, int x, int y, int width, int height, long date) {
        void fm;
        String numericDay = dayOfMonthFormatter.format(date);
        g.setColor(this.leadingDayForeground);
        int n = this.monthView.getBoxPaddingX();
        int boxPaddingX = this.monthView.getBoxPaddingY();
        FontMetrics boxPaddingY = g.getFontMetrics();
        g.drawString(numericDay, this.isLeftToRight ? x + fm + this.boxWidth - boxPaddingY.stringWidth(numericDay) : x + fm + this.boxWidth - boxPaddingY.stringWidth(numericDay) - 1, y + boxPaddingX + boxPaddingY.getAscent());
    }

    protected void paintTrailingDayBackground(Graphics g, int x, int y, int width, int height, long date) {
        this.paintLeadingDayBackground(g, x, y, width, height, date);
    }

    /*
     * WARNING - void declaration
     */
    protected void paintTrailingDayForeground(Graphics g, int x, int y, int width, int height, long date) {
        void fm;
        String numericDay = dayOfMonthFormatter.format(date);
        g.setColor(this.trailingDayForeground);
        int n = this.monthView.getBoxPaddingX();
        int boxPaddingX = this.monthView.getBoxPaddingY();
        FontMetrics boxPaddingY = g.getFontMetrics();
        g.drawString(numericDay, this.isLeftToRight ? x + fm + this.boxWidth - boxPaddingY.stringWidth(numericDay) : x + fm + this.boxWidth - boxPaddingY.stringWidth(numericDay) - 1, y + boxPaddingX + boxPaddingY.getAscent());
    }

    private long cleanupDate(long date) {
        Calendar cal = this.monthView.getCalendar();
        cal.setTimeInMillis(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    protected void paintBackground(Rectangle clip, Graphics g) {
        if (this.monthView.isOpaque()) {
            g.setColor(this.monthView.getBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
    }

    private class KeyboardAction
    extends AbstractAction {
        public static final int ACCEPT_SELECTION = 0;
        public static final int CANCEL_SELECTION = 1;
        public static final int SELECT_PREVIOUS_DAY = 2;
        public static final int SELECT_NEXT_DAY = 3;
        public static final int SELECT_DAY_PREVIOUS_WEEK = 4;
        public static final int SELECT_DAY_NEXT_WEEK = 5;
        public static final int ADJUST_SELECTION_PREVIOUS_DAY = 6;
        public static final int ADJUST_SELECTION_NEXT_DAY = 7;
        public static final int ADJUST_SELECTION_PREVIOUS_WEEK = 8;
        public static final int ADJUST_SELECTION_NEXT_WEEK = 9;
        private int action;

        public KeyboardAction(int action) {
            this.action = action;
        }

        public void actionPerformed(ActionEvent ev) {
            JXMonthView.SelectionMode selectionMode = BasicMonthViewUI.this.monthView.getSelectionMode();
            if (selectionMode != JXMonthView.SelectionMode.NO_SELECTION) {
                if (!BasicMonthViewUI.this.isUsingKeyboard()) {
                    BasicMonthViewUI.this.originalDateSpan = BasicMonthViewUI.this.monthView.getSelection();
                }
                if (this.action >= 0 && this.action <= 1) {
                    if (this.action == 1) {
                        if (BasicMonthViewUI.this.originalDateSpan != null && !BasicMonthViewUI.this.originalDateSpan.isEmpty()) {
                            BasicMonthViewUI.this.monthView.setSelectionInterval((Date)BasicMonthViewUI.this.originalDateSpan.first(), (Date)BasicMonthViewUI.this.originalDateSpan.last());
                        } else {
                            BasicMonthViewUI.this.monthView.clearSelection();
                        }
                        BasicMonthViewUI.this.monthView.cancelSelection();
                    } else {
                        BasicMonthViewUI.this.monthView.commitSelection();
                    }
                    BasicMonthViewUI.this.setUsingKeyboard(false);
                } else if (this.action >= 2 && this.action <= 5) {
                    BasicMonthViewUI.this.setUsingKeyboard(true);
                    BasicMonthViewUI.this.monthView.getSelectionModel().setAdjusting(true);
                    BasicMonthViewUI.this.pivotDate = -1L;
                    this.traverse(this.action);
                } else if (selectionMode == JXMonthView.SelectionMode.SINGLE_INTERVAL_SELECTION && this.action >= 6 && this.action <= 9) {
                    BasicMonthViewUI.this.setUsingKeyboard(true);
                    BasicMonthViewUI.this.monthView.getSelectionModel().setAdjusting(true);
                    this.addToSelection(this.action);
                }
            }
        }

        private void traverse(int action) {
            long oldStart = BasicMonthViewUI.this.selection.isEmpty() ? System.currentTimeMillis() : BasicMonthViewUI.this.selection.first().getTime();
            Calendar cal = BasicMonthViewUI.this.monthView.getCalendar();
            cal.setTimeInMillis(oldStart);
            switch (action) {
                case 2: {
                    cal.add(5, -1);
                    break;
                }
                case 3: {
                    cal.add(5, 1);
                    break;
                }
                case 4: {
                    cal.add(5, -7);
                    break;
                }
                case 5: {
                    cal.add(5, 7);
                }
            }
            long newStartDate = cal.getTimeInMillis();
            if (newStartDate != oldStart) {
                Date startDate = new Date(newStartDate);
                BasicMonthViewUI.this.monthView.setSelectionInterval(startDate, startDate);
                BasicMonthViewUI.this.monthView.ensureDateVisible(newStartDate);
            }
            cal.setTimeInMillis(BasicMonthViewUI.this.firstDisplayedDate);
        }

        private void addToSelection(int action) {
            long newStartDate;
            long newEndDate;
            long selectionEnd;
            long selectionStart;
            if (!BasicMonthViewUI.this.selection.isEmpty()) {
                long l;
                long l2 = l = BasicMonthViewUI.this.selection.first().getTime();
                selectionEnd = selectionStart = BasicMonthViewUI.this.selection.last().getTime();
            } else {
                selectionEnd = selectionStart = (newEndDate = (newStartDate = BasicMonthViewUI.this.cleanupDate(System.currentTimeMillis())));
            }
            if (-1L == BasicMonthViewUI.this.pivotDate) {
                BasicMonthViewUI.this.pivotDate = newEndDate;
            }
            boolean isForward = true;
            Calendar cal = BasicMonthViewUI.this.monthView.getCalendar();
            switch (action) {
                case 6: {
                    if (selectionEnd <= BasicMonthViewUI.this.pivotDate) {
                        cal.setTimeInMillis(newEndDate);
                        cal.add(5, -1);
                        newEndDate = cal.getTimeInMillis();
                    } else {
                        cal.setTimeInMillis(selectionEnd);
                        cal.add(5, -1);
                        selectionEnd = cal.getTimeInMillis();
                    }
                    isForward = false;
                    break;
                }
                case 7: {
                    if (newEndDate >= BasicMonthViewUI.this.pivotDate) {
                        cal.setTimeInMillis(selectionEnd);
                        cal.add(5, 1);
                        newEndDate = BasicMonthViewUI.this.pivotDate;
                        selectionEnd = cal.getTimeInMillis();
                        break;
                    }
                    cal.setTimeInMillis(newEndDate);
                    cal.add(5, 1);
                    newEndDate = cal.getTimeInMillis();
                    break;
                }
                case 8: {
                    if (selectionEnd <= BasicMonthViewUI.this.pivotDate) {
                        cal.setTimeInMillis(newEndDate);
                        cal.add(5, -7);
                        newEndDate = cal.getTimeInMillis();
                    } else {
                        cal.setTimeInMillis(selectionEnd);
                        cal.add(5, -7);
                        long newTime = cal.getTimeInMillis();
                        if (newTime <= BasicMonthViewUI.this.pivotDate) {
                            newEndDate = newTime;
                            selectionEnd = BasicMonthViewUI.this.pivotDate;
                        } else {
                            selectionEnd = cal.getTimeInMillis();
                        }
                    }
                    isForward = false;
                    break;
                }
                case 9: {
                    if (newEndDate >= BasicMonthViewUI.this.pivotDate) {
                        cal.setTimeInMillis(selectionEnd);
                        cal.add(5, 7);
                        selectionEnd = cal.getTimeInMillis();
                        break;
                    }
                    cal.setTimeInMillis(newEndDate);
                    cal.add(5, 7);
                    long newTime = cal.getTimeInMillis();
                    if (newTime >= BasicMonthViewUI.this.pivotDate) {
                        newEndDate = BasicMonthViewUI.this.pivotDate;
                        selectionEnd = newTime;
                        break;
                    }
                    newEndDate = cal.getTimeInMillis();
                }
            }
            if (newEndDate != newStartDate || selectionEnd != selectionStart) {
                BasicMonthViewUI.this.monthView.setSelectionInterval(new Date(newEndDate), new Date(selectionEnd));
                BasicMonthViewUI.this.monthView.ensureDateVisible(isForward ? selectionEnd : newEndDate);
            }
            cal.setTimeInMillis(BasicMonthViewUI.this.firstDisplayedDate);
        }
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener,
    LayoutManager,
    PropertyChangeListener,
    DateSelectionListener {
        private boolean armed;
        private long startDate;
        private long endDate;

        private Handler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            JXMonthView.SelectionMode selectionMode;
            BasicMonthViewUI.this.setUsingKeyboard(false);
            if (!BasicMonthViewUI.this.monthView.isEnabled()) {
                return;
            }
            if (!BasicMonthViewUI.this.monthView.hasFocus() && BasicMonthViewUI.this.monthView.isFocusable()) {
                BasicMonthViewUI.this.monthView.requestFocusInWindow();
            }
            if (BasicMonthViewUI.this.monthView.isTraversable()) {
                Date upperBound;
                int arrowType = BasicMonthViewUI.this.getTraversableButtonAt(e.getX(), e.getY());
                if (arrowType == 1) {
                    Date lowerBound = BasicMonthViewUI.this.monthView.getLowerBound();
                    if (lowerBound == null || lowerBound.getTime() < BasicMonthViewUI.this.firstDisplayedDate) {
                        BasicMonthViewUI.this.monthView.setFirstDisplayedDate(DateUtils.getPreviousMonth(BasicMonthViewUI.this.firstDisplayedDate));
                        BasicMonthViewUI.this.calculateDirtyRectForSelection();
                        return;
                    }
                } else if (arrowType == 2 && ((upperBound = BasicMonthViewUI.this.monthView.getUpperBound()) == null || upperBound.getTime() > BasicMonthViewUI.this.lastDisplayedDate)) {
                    BasicMonthViewUI.this.monthView.setFirstDisplayedDate(DateUtils.getNextMonth(BasicMonthViewUI.this.firstDisplayedDate));
                    BasicMonthViewUI.this.calculateDirtyRectForSelection();
                    return;
                }
            }
            if ((selectionMode = BasicMonthViewUI.this.monthView.getSelectionMode()) == JXMonthView.SelectionMode.NO_SELECTION) {
                return;
            }
            long l = BasicMonthViewUI.this.monthView.getDayAt(e.getX(), e.getY());
            if (l == -1L) {
                return;
            }
            this.startDate = l;
            this.endDate = l;
            if (selectionMode == JXMonthView.SelectionMode.SINGLE_INTERVAL_SELECTION || selectionMode == JXMonthView.SelectionMode.WEEK_INTERVAL_SELECTION || selectionMode == JXMonthView.SelectionMode.MULTIPLE_INTERVAL_SELECTION) {
                BasicMonthViewUI.this.pivotDate = l;
            }
            BasicMonthViewUI.this.monthView.getSelectionModel().setAdjusting(true);
            if (selectionMode == JXMonthView.SelectionMode.MULTIPLE_INTERVAL_SELECTION && e.isControlDown()) {
                BasicMonthViewUI.this.monthView.addSelectionInterval(new Date(this.startDate), new Date(this.endDate));
            } else {
                BasicMonthViewUI.this.monthView.setSelectionInterval(new Date(this.startDate), new Date(this.endDate));
            }
            this.armed = true;
        }

        public void mouseReleased(MouseEvent e) {
            BasicMonthViewUI.this.setUsingKeyboard(false);
            if (!BasicMonthViewUI.this.monthView.isEnabled()) {
                return;
            }
            if (!BasicMonthViewUI.this.monthView.hasFocus() && BasicMonthViewUI.this.monthView.isFocusable()) {
                BasicMonthViewUI.this.monthView.requestFocusInWindow();
            }
            if (this.armed) {
                BasicMonthViewUI.this.monthView.commitSelection();
            }
            this.armed = false;
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            BasicMonthViewUI.this.setUsingKeyboard(false);
            JXMonthView.SelectionMode selectionMode = BasicMonthViewUI.this.monthView.getSelectionMode();
            if (!BasicMonthViewUI.this.monthView.isEnabled() || selectionMode == JXMonthView.SelectionMode.NO_SELECTION) {
                return;
            }
            long selected = BasicMonthViewUI.this.monthView.getDayAt(e.getX(), e.getY());
            if (selected == -1L) {
                return;
            }
            long oldStart = this.startDate;
            long oldEnd = this.endDate;
            if (selectionMode == JXMonthView.SelectionMode.SINGLE_SELECTION) {
                if (selected == oldStart) {
                    return;
                }
                this.startDate = selected;
                this.endDate = selected;
            } else if (selected <= BasicMonthViewUI.this.pivotDate) {
                this.startDate = selected;
                this.endDate = BasicMonthViewUI.this.pivotDate;
            } else if (selected > BasicMonthViewUI.this.pivotDate) {
                this.startDate = BasicMonthViewUI.this.pivotDate;
                this.endDate = selected;
            }
            if (oldStart == this.startDate && oldEnd == this.endDate) {
                return;
            }
            if (selectionMode == JXMonthView.SelectionMode.MULTIPLE_INTERVAL_SELECTION && e.isControlDown()) {
                BasicMonthViewUI.this.monthView.addSelectionInterval(new Date(this.startDate), new Date(this.endDate));
            } else {
                BasicMonthViewUI.this.monthView.setSelectionInterval(new Date(this.startDate), new Date(this.endDate));
            }
            this.armed = true;
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            this.layoutContainer(parent);
            return new Dimension(BasicMonthViewUI.this.dim);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        /*
         * WARNING - void declaration
         */
        public void layoutContainer(Container parent) {
            int newHeight;
            int val;
            String[] fm2;
            void currWidth;
            int cal;
            int n = 0;
            int longestMonth = 0;
            int daysInLongestMonth = 0;
            FontMetrics fontMetrics = BasicMonthViewUI.this.monthView.getFontMetrics(BasicMonthViewUI.this.derivedFont);
            Calendar longestMonthWidth = BasicMonthViewUI.this.monthView.getCalendar();
            longestMonthWidth.set(2, longestMonthWidth.getMinimum(2));
            longestMonthWidth.set(5, longestMonthWidth.getActualMinimum(5));
            for (int fm2 = 0; fm2 < longestMonthWidth.getMaximum(2); ++fm2) {
                int i;
                cal = fontMetrics.stringWidth(monthsOfTheYear[fm2]);
                if (cal > daysInLongestMonth) {
                    daysInLongestMonth = cal;
                }
                if ((i = longestMonthWidth.getActualMaximum(5)) > longestMonth) {
                    int currDays = longestMonthWidth.get(2);
                    longestMonth = i;
                }
                longestMonthWidth.add(2, 1);
            }
            BasicMonthViewUI.this.boxHeight = currWidth.getHeight();
            for (String dayOfTheWeek : fm2 = BasicMonthViewUI.this.monthView.getDaysOfTheWeek()) {
                cal = currWidth.stringWidth(dayOfTheWeek);
                if (cal <= BasicMonthViewUI.this.boxWidth) continue;
                BasicMonthViewUI.this.boxWidth = cal;
            }
            longestMonthWidth.set(2, n);
            longestMonthWidth.set(5, longestMonthWidth.getActualMinimum(5));
            for (int i = 0; i < longestMonth; ++i) {
                cal = currWidth.stringWidth(dayOfMonthFormatter.format(longestMonthWidth.getTime()));
                if (cal > BasicMonthViewUI.this.boxWidth) {
                    BasicMonthViewUI.this.boxWidth = cal;
                }
                longestMonthWidth.add(5, 1);
            }
            boolean showingWeekNumber = BasicMonthViewUI.this.monthView.isShowingWeekNumber();
            if (showingWeekNumber && (cal = currWidth.stringWidth(Integer.toString(val = longestMonthWidth.getActualMaximum(3)))) > BasicMonthViewUI.this.boxWidth) {
                BasicMonthViewUI.this.boxWidth = cal;
            }
            BasicMonthViewUI.this.monthBoxHeight = BasicMonthViewUI.this.boxHeight;
            if (BasicMonthViewUI.this.monthView.isTraversable() && (newHeight = BasicMonthViewUI.this.monthDownImage.getIconHeight() + BasicMonthViewUI.this.arrowPaddingY + BasicMonthViewUI.this.arrowPaddingY) > BasicMonthViewUI.this.monthBoxHeight) {
                BasicMonthViewUI.this.monthBoxHeight = newHeight;
            }
            int boxPaddingX = BasicMonthViewUI.this.monthView.getBoxPaddingX();
            int boxPaddingY = BasicMonthViewUI.this.monthView.getBoxPaddingY();
            ((BasicMonthViewUI)BasicMonthViewUI.this).dim.width = (BasicMonthViewUI.this.boxWidth + 2 * boxPaddingX) * 7;
            if (((BasicMonthViewUI)BasicMonthViewUI.this).dim.width < daysInLongestMonth) {
                double d = daysInLongestMonth - ((BasicMonthViewUI)BasicMonthViewUI.this).dim.width;
                if (BasicMonthViewUI.this.monthView.isTraversable()) {
                    d += (double)(BasicMonthViewUI.this.monthDownImage.getIconWidth() + BasicMonthViewUI.this.monthUpImage.getIconWidth() + BasicMonthViewUI.this.arrowPaddingX * 4);
                }
                BasicMonthViewUI.this.boxWidth = (int)((double)BasicMonthViewUI.this.boxWidth + Math.ceil(d / 7.0));
            }
            BasicMonthViewUI.this.fullBoxWidth = BasicMonthViewUI.this.boxWidth + boxPaddingX + boxPaddingX;
            BasicMonthViewUI.this.fullBoxHeight = BasicMonthViewUI.this.boxHeight + boxPaddingY + boxPaddingY;
            BasicMonthViewUI.this.fullMonthBoxHeight = BasicMonthViewUI.this.monthBoxHeight + boxPaddingY + boxPaddingY;
            BasicMonthViewUI.this.calendarWidth = BasicMonthViewUI.this.fullBoxWidth * 7;
            if (showingWeekNumber) {
                BasicMonthViewUI.this.calendarWidth += BasicMonthViewUI.this.fullBoxWidth;
            }
            BasicMonthViewUI.this.calendarHeight = BasicMonthViewUI.this.fullBoxHeight * 7 + BasicMonthViewUI.this.fullMonthBoxHeight;
            int prefRows = BasicMonthViewUI.this.monthView.getPreferredRows();
            ((BasicMonthViewUI)BasicMonthViewUI.this).dim.height = BasicMonthViewUI.this.calendarHeight * prefRows + 10 * (prefRows - 1);
            int n2 = BasicMonthViewUI.this.monthView.getPreferredCols();
            ((BasicMonthViewUI)BasicMonthViewUI.this).dim.width = BasicMonthViewUI.this.calendarWidth * n2 + 10 * (n2 - 1);
            Insets insets = BasicMonthViewUI.this.monthView.getInsets();
            ((BasicMonthViewUI)BasicMonthViewUI.this).dim.width += insets.left + insets.right;
            ((BasicMonthViewUI)BasicMonthViewUI.this).dim.height += insets.top + insets.bottom;
            longestMonthWidth.setTimeInMillis(BasicMonthViewUI.this.firstDisplayedDate);
            BasicMonthViewUI.this.calculateNumDisplayedCals();
            BasicMonthViewUI.this.calculateStartPosition();
            if (!BasicMonthViewUI.this.monthView.getSelectionModel().isSelectionEmpty()) {
                long l = BasicMonthViewUI.this.selection.first().getTime();
                if (l > BasicMonthViewUI.this.lastDisplayedDate || l < BasicMonthViewUI.this.firstDisplayedDate) {
                    BasicMonthViewUI.this.monthView.ensureDateVisible(l);
                } else {
                    BasicMonthViewUI.this.calculateDirtyRectForSelection();
                }
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if ("componentOrientation".equals(property)) {
                BasicMonthViewUI.this.isLeftToRight = BasicMonthViewUI.this.monthView.getComponentOrientation().isLeftToRight();
                BasicMonthViewUI.this.monthView.revalidate();
                BasicMonthViewUI.this.calculateStartPosition();
                BasicMonthViewUI.this.calculateDirtyRectForSelection();
            } else if ("ensureDateVisibility".equals(property)) {
                BasicMonthViewUI.this.calculateDirtyRectForSelection();
            } else if ("selectionModel".equals(property)) {
                DateSelectionModel selectionModel = (DateSelectionModel)evt.getOldValue();
                selectionModel.removeDateSelectionListener(BasicMonthViewUI.this.getHandler());
                selectionModel = (DateSelectionModel)evt.getNewValue();
                selectionModel.addDateSelectionListener(BasicMonthViewUI.this.getHandler());
            } else if ("firstDisplayedDate".equals(property)) {
                BasicMonthViewUI.this.firstDisplayedDate = (Long)evt.getNewValue();
            } else if ("firstDisplayedMonth".equals(property)) {
                BasicMonthViewUI.this.firstDisplayedMonth = (Integer)evt.getNewValue();
            } else if ("firstDisplayedYear".equals(property)) {
                BasicMonthViewUI.this.firstDisplayedYear = (Integer)evt.getNewValue();
            } else if ("today".equals(property)) {
                BasicMonthViewUI.this.today = (Long)evt.getNewValue();
            } else if ("boxPaddingX".equals(property) || "boxPaddingY".equals(property) || "traversable".equals(property) || "daysOfTheWeek".equals(property) || "border".equals(property) || "weekNumber".equals(property)) {
                BasicMonthViewUI.this.monthView.revalidate();
            } else if ("font".equals(property)) {
                BasicMonthViewUI.this.derivedFont = BasicMonthViewUI.this.createDerivedFont();
                BasicMonthViewUI.this.monthView.revalidate();
            } else if ("componentInputMapEnabled".equals(property)) {
                BasicMonthViewUI.this.updateComponentInputMap();
            }
        }

        public void valueChanged(DateSelectionEvent ev) {
            BasicMonthViewUI.this.selection = ev.getSelection();
            BasicMonthViewUI.this.monthView.repaint(BasicMonthViewUI.this.dirtyRect);
            BasicMonthViewUI.this.calculateDirtyRectForSelection();
            BasicMonthViewUI.this.monthView.repaint(BasicMonthViewUI.this.dirtyRect);
        }
    }
}

