/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import org.shiftone.jrat.depends.jdesktop.swingx.JXTipOfTheDay;
import org.shiftone.jrat.depends.jdesktop.swingx.plaf.TipOfTheDayUI;
import org.shiftone.jrat.depends.jdesktop.swingx.tips.TipOfTheDayModel;
import org.shiftone.jrat.depends.jdesktop.swingx.util.UIManagerUtils;

public class BasicTipOfTheDayUI
extends TipOfTheDayUI {
    protected JXTipOfTheDay tipPane;
    protected JPanel tipArea;
    protected Component currentTipComponent;
    protected Font tipFont;
    protected PropertyChangeListener changeListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicTipOfTheDayUI((JXTipOfTheDay)c);
    }

    public BasicTipOfTheDayUI(JXTipOfTheDay tipPane) {
        this.tipPane = tipPane;
    }

    public JDialog createDialog(Component parentComponent, JXTipOfTheDay.ShowOnStartupChoice choice) {
        return this.createDialog(parentComponent, choice, true);
    }

    /*
     * WARNING - void declaration
     */
    protected JDialog createDialog(Component parentComponent, final JXTipOfTheDay.ShowOnStartupChoice choice, boolean showPreviousButton) {
        void showOnStartupBox;
        JCheckBox controls;
        void dialog;
        String title = UIManager.getString("TipOfTheDay.dialogTitle");
        Window window = parentComponent == null ? JOptionPane.getRootFrame() : (parentComponent instanceof Window ? (Window)parentComponent : SwingUtilities.getWindowAncestor(parentComponent));
        final JDialog window2 = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)dialog, title, true);
        window2.getContentPane().setLayout(new BorderLayout(10, 10));
        window2.getContentPane().add((Component)this.tipPane, "Center");
        ((JComponent)window2.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel = new JPanel(new BorderLayout());
        window2.add("South", jPanel);
        if (choice != null) {
            controls = new JCheckBox(UIManager.getString("TipOfTheDay.showOnStartupText"), choice.isShowingOnStartup());
            showOnStartupBox.add((Component)controls, "Center");
        } else {
            controls = null;
        }
        JPanel buttons = new JPanel(new GridLayout(1, showPreviousButton ? 3 : 2, 9, 0));
        showOnStartupBox.add((Component)buttons, "After");
        if (showPreviousButton) {
            JButton previousTipButton = new JButton(UIManager.getString("TipOfTheDay.previousTipText"));
            buttons.add(previousTipButton);
            previousTipButton.addActionListener(this.getActionMap().get("previousTip"));
        }
        JButton nextTipButton = new JButton(UIManager.getString("TipOfTheDay.nextTipText"));
        buttons.add(nextTipButton);
        nextTipButton.addActionListener(this.getActionMap().get("nextTip"));
        JButton closeButton = new JButton(UIManager.getString("TipOfTheDay.closeText"));
        buttons.add(closeButton);
        final ActionListener saveChoice = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (choice != null) {
                    choice.setShowingOnStartup(controls.isSelected());
                }
                window2.setVisible(false);
            }
        };
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                window2.setVisible(false);
                saveChoice.actionPerformed(null);
            }
        });
        window2.getRootPane().setDefaultButton(closeButton);
        window2.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                saveChoice.actionPerformed(null);
            }
        });
        ((JComponent)window2.getContentPane()).registerKeyboardAction(saveChoice, KeyStroke.getKeyStroke(27, 0), 2);
        window2.pack();
        window2.setLocationRelativeTo(parentComponent);
        return window2;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.installDefaults();
        this.installKeyboardActions();
        this.installComponents();
        this.installListeners();
        this.showCurrentTip();
    }

    protected void installKeyboardActions() {
        ActionMap map = this.getActionMap();
        if (map != null) {
            SwingUtilities.replaceUIActionMap(this.tipPane, map);
        }
    }

    ActionMap getActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("previousTip", new PreviousTipAction());
        map.put("nextTip", new NextTipAction());
        return map;
    }

    protected void installListeners() {
        this.changeListener = this.createChangeListener();
        this.tipPane.addPropertyChangeListener(this.changeListener);
    }

    protected PropertyChangeListener createChangeListener() {
        return new ChangeListener();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tipPane, "TipOfTheDay.background", "TipOfTheDay.foreground", "TipOfTheDay.font");
        LookAndFeel.installBorder(this.tipPane, "TipOfTheDay.border");
        this.tipFont = UIManager.getFont("TipOfTheDay.tipFont");
        this.tipPane.setOpaque(true);
    }

    protected void installComponents() {
        this.tipPane.setLayout(new BorderLayout());
        JLabel tipIcon = new JLabel(UIManager.getString("TipOfTheDay.didYouKnowText"));
        tipIcon.setIcon(UIManager.getIcon("TipOfTheDay.icon"));
        tipIcon.setBorder(BorderFactory.createEmptyBorder(22, 15, 22, 15));
        this.tipPane.add("North", tipIcon);
        this.tipArea = new JPanel(new BorderLayout(2, 2));
        this.tipArea.setOpaque(false);
        this.tipArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.tipPane.add("Center", this.tipArea);
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(420, 175);
    }

    protected void showCurrentTip() {
        int currentTip;
        if (this.currentTipComponent != null) {
            this.tipArea.remove(this.currentTipComponent);
        }
        if ((currentTip = this.tipPane.getCurrentTip()) == -1) {
            JLabel label = new JLabel();
            label.setOpaque(true);
            label.setBackground(UIManager.getColor("TextArea.background"));
            this.currentTipComponent = label;
            this.tipArea.add("Center", this.currentTipComponent);
            return;
        }
        if (this.tipPane.getModel() == null || this.tipPane.getModel().getTipCount() == 0 || currentTip < 0 && currentTip >= this.tipPane.getModel().getTipCount()) {
            this.currentTipComponent = new JLabel();
        } else {
            TipOfTheDayModel.Tip tip = this.tipPane.getModel().getTipAt(currentTip);
            Object tipObject = tip.getTip();
            if (tipObject instanceof Component) {
                this.currentTipComponent = (Component)tipObject;
            } else if (tipObject instanceof Icon) {
                this.currentTipComponent = new JLabel((Icon)tipObject);
            } else {
                String text;
                JScrollPane tipScroll = new JScrollPane();
                tipScroll.setBorder(null);
                tipScroll.setOpaque(false);
                tipScroll.getViewport().setOpaque(false);
                tipScroll.setBorder(null);
                String string = text = tipObject == null ? "" : tipObject.toString();
                if (text.toLowerCase().startsWith("<html>")) {
                    JEditorPane editor = new JEditorPane("text/html", text);
                    UIManagerUtils.htmlize(editor, this.tipPane.getFont());
                    editor.setEditable(false);
                    editor.setBorder(null);
                    editor.setMargin(null);
                    editor.setOpaque(false);
                    tipScroll.getViewport().setView(editor);
                } else {
                    JTextArea area = new JTextArea(text);
                    area.setFont(this.tipPane.getFont());
                    area.setEditable(false);
                    area.setLineWrap(true);
                    area.setWrapStyleWord(true);
                    area.setBorder(null);
                    area.setMargin(null);
                    area.setOpaque(false);
                    tipScroll.getViewport().setView(area);
                }
                this.currentTipComponent = tipScroll;
            }
        }
        this.tipArea.add("Center", this.currentTipComponent);
        this.tipArea.revalidate();
        this.tipArea.repaint();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        super.uninstallUI(c);
    }

    protected void uninstallListeners() {
        this.tipPane.removePropertyChangeListener(this.changeListener);
    }

    protected void uninstallComponents() {
    }

    protected void uninstallDefaults() {
    }

    class NextTipAction
    extends AbstractAction {
        public NextTipAction() {
            super("nextTip");
        }

        public void actionPerformed(ActionEvent e) {
            BasicTipOfTheDayUI.this.tipPane.nextTip();
        }

        public boolean isEnabled() {
            return BasicTipOfTheDayUI.this.tipPane.isEnabled();
        }
    }

    class PreviousTipAction
    extends AbstractAction {
        public PreviousTipAction() {
            super("previousTip");
        }

        public void actionPerformed(ActionEvent e) {
            BasicTipOfTheDayUI.this.tipPane.previousTip();
        }

        public boolean isEnabled() {
            return BasicTipOfTheDayUI.this.tipPane.isEnabled();
        }
    }

    class ChangeListener
    implements PropertyChangeListener {
        ChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("currentTip".equals(evt.getPropertyName())) {
                BasicTipOfTheDayUI.this.showCurrentTip();
            }
        }
    }
}

