/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.plaf.macosx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.shiftone.jrat.depends.jdesktop.swingx.action.AbstractActionExt;
import org.shiftone.jrat.depends.jdesktop.swingx.error.ErrorInfo;
import org.shiftone.jrat.depends.jdesktop.swingx.error.ErrorLevel;
import org.shiftone.jrat.depends.jdesktop.swingx.plaf.basic.BasicErrorPaneUI;

public class MacOSXErrorPaneUI
extends BasicErrorPaneUI {
    private JLabel titleLabel;
    private JEditorPane disclaimerText;

    protected void configureDetailsButton(boolean expanded) {
        if (expanded) {
            this.detailButton.setText(UIManager.getString("JXErrorPane.mac.details_contract_text"));
            this.detailButton.setIcon(UIManager.getIcon("Tree.expandedIcon"));
        } else {
            this.detailButton.setText(UIManager.getString("JXErrorPane.mac.details_expand_text"));
            this.detailButton.setIcon(UIManager.getIcon("Tree.collapsedIcon"));
        }
    }

    protected void configureReportAction(AbstractActionExt reportAction) {
        reportAction.setName(UIManager.getString("JXErrorPane.mac.report_button_text"));
    }

    public static ComponentUI createUI(JComponent c) {
        return new MacOSXErrorPaneUI();
    }

    public JFrame getErrorFrame(Component owner) {
        JFrame frame = super.getErrorFrame(owner);
        frame.setTitle(" ");
        return frame;
    }

    public JDialog getErrorDialog(Component owner) {
        JDialog dlg = super.getErrorDialog(owner);
        dlg.setTitle(" ");
        System.out.println(this.reportButton.getPreferredSize());
        return dlg;
    }

    public JInternalFrame getErrorInternalFrame(Component owner) {
        JInternalFrame frame = super.getErrorInternalFrame(owner);
        frame.setTitle(" ");
        return frame;
    }

    protected LayoutManager createErrorPaneLayout() {
        this.createExtraComponents();
        GridBagLayout layout = new GridBagLayout();
        try {
            layout.addLayoutComponent(this.iconLabel, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 17), 0, 0));
            layout.addLayoutComponent(this.titleLabel, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 12, 0), 0, 0));
            layout.addLayoutComponent(this.errorMessage, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
            layout.addLayoutComponent(this.detailButton, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 6, 0), 0, 0));
            layout.addLayoutComponent(this.detailsPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 6, 0), 0, 0));
            layout.addLayoutComponent(this.disclaimerText, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 6, 0), 0, 0));
            layout.addLayoutComponent(this.closeButton, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
            layout.addLayoutComponent(this.reportButton, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return layout;
    }

    protected LayoutManager createDetailPanelLayout() {
        GridBagLayout layout = new GridBagLayout();
        layout.addLayoutComponent(this.detailsScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.copyToClipboardButton.setVisible(false);
        return layout;
    }

    protected void reinit() {
        super.reinit();
        ErrorInfo info = this.pane == null ? null : this.pane.getErrorInfo();
        this.titleLabel.setText(info == null ? "Unknown Error" : info.getTitle());
        Object finePrint = this.pane.getClientProperty("fine-print");
        String text = finePrint == null ? null : finePrint.toString();
        this.disclaimerText.setText(text);
        this.disclaimerText.setVisible(text != null);
        if (info != null && info.getErrorLevel() == ErrorLevel.FATAL) {
            this.closeButton.setText(UIManager.getString("JXErrorPane.fatal_button_text"));
        } else {
            this.closeButton.setText(UIManager.getString("JXErrorPane.mac.ok_button_text"));
        }
    }

    protected Dimension calculatePreferredDialogSize() {
        if (this.disclaimerText.isVisible()) {
            return new Dimension(588, 270);
        }
        return new Dimension(588, 216);
    }

    protected int getDetailsHeight() {
        return 150;
    }

    private void createExtraComponents() {
        this.titleLabel = new JLabel("Unknown Error");
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.pane.add(this.titleLabel);
        Font f = this.errorMessage.getFont();
        if (f != null) {
            this.errorMessage.setFont(f.deriveFont((float)f.getSize() - 2.0f));
        }
        this.disclaimerText = new JEditorPane();
        this.disclaimerText.setContentType("text/html");
        this.disclaimerText.setVisible(false);
        this.disclaimerText.setEditable(false);
        this.disclaimerText.setOpaque(false);
        this.disclaimerText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        if (f != null) {
            this.disclaimerText.setFont(f.deriveFont((float)f.getSize() - 2.0f));
        }
        this.pane.add(this.disclaimerText);
        this.detailButton.setBorderPainted(false);
        this.detailButton.setContentAreaFilled(false);
        this.detailButton.setBorder(BorderFactory.createEmptyBorder());
        this.detailButton.setMargin(new Insets(0, 0, 0, 0));
        this.detailButton.setIcon(UIManager.getIcon("Tree.collapsedIcon"));
        this.detailButton.setText(UIManager.getString("JXErrorPane.mac.details_expand_text"));
        this.closeButton.setText(UIManager.getString("JXErrorPane.mac.ok_button_text"));
    }
}

