/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.plaf.windows;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.shiftone.jrat.depends.jdesktop.swingx.JXStatusBar;
import org.shiftone.jrat.depends.jdesktop.swingx.plaf.basic.BasicStatusBarUI;

public class WindowsStatusBarUI
extends BasicStatusBarUI {
    private BufferedImage leftImage;
    private BufferedImage middleImage;
    private BufferedImage rightImage;

    public WindowsStatusBarUI() {
        try {
            this.leftImage = ImageIO.read(this.getClass().getResource("resources/statusbar-left.png"));
            this.middleImage = ImageIO.read(this.getClass().getResource("resources/statusbar-middle.png"));
            this.rightImage = ImageIO.read(this.getClass().getResource("resources/statusbar-right.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new WindowsStatusBarUI();
    }

    protected void paintBackground(Graphics2D g, JXStatusBar statusBar) {
        Graphics2D g2 = g;
        g2.drawImage(this.leftImage, 0, 0, this.leftImage.getWidth(), statusBar.getHeight(), null);
        g2.drawImage(this.middleImage, this.leftImage.getWidth(), 0, statusBar.getWidth() - this.leftImage.getWidth() - this.rightImage.getWidth(), statusBar.getHeight(), null);
        g2.drawImage(this.rightImage, statusBar.getWidth() - this.rightImage.getWidth(), 0, this.rightImage.getWidth(), statusBar.getHeight(), null);
    }

    protected void getSeparatorInsets(Insets insets) {
        insets.top = 1;
        insets.left = 4;
        insets.bottom = 0;
        insets.right = 4;
    }
}

