/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.renderer;

import java.io.Serializable;
import javax.swing.JComponent;
import org.shiftone.jrat.depends.jdesktop.swingx.renderer.CellContext;
import org.shiftone.jrat.depends.jdesktop.swingx.renderer.DefaultVisuals;
import org.shiftone.jrat.depends.jdesktop.swingx.renderer.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentProvider<T extends JComponent>
implements Serializable {
    protected T rendererComponent;
    protected DefaultVisuals<T> defaultVisuals;
    protected int alignment;
    protected StringValue formatter;

    public ComponentProvider() {
        this.setHorizontalAlignment(10);
        this.setToStringConverter(null);
        this.rendererComponent = this.createRendererComponent();
        this.defaultVisuals = this.createRendererController();
    }

    public T getRendererComponent(CellContext context) {
        if (context != null) {
            this.configureVisuals(context);
            this.configureContent(context);
        }
        return this.rendererComponent;
    }

    public void setHorizontalAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getHorizontalAlignment() {
        return this.alignment;
    }

    public void setToStringConverter(StringValue formatter) {
        if (formatter == null) {
            formatter = StringValue.TO_STRING;
        }
        this.formatter = formatter;
    }

    public StringValue getToStringConverter() {
        return this.formatter;
    }

    public String getStringValue(CellContext context) {
        Object value = null;
        if (context != null) {
            value = context.getValue();
        }
        return this.formatter.getString(value);
    }

    protected void configureVisuals(CellContext context) {
        this.defaultVisuals.configureVisuals(this.rendererComponent, context);
    }

    protected void configureContent(CellContext context) {
        this.configureState(context);
        this.format(context);
    }

    protected abstract void format(CellContext var1);

    protected abstract void configureState(CellContext var1);

    protected abstract T createRendererComponent();

    protected DefaultVisuals<T> createRendererController() {
        return new DefaultVisuals();
    }

    protected DefaultVisuals<T> getRendererController() {
        return this.defaultVisuals;
    }
}

