/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.shiftone.jrat.depends.jdesktop.swingx.renderer.CellContext;
import org.shiftone.jrat.depends.jdesktop.swingx.renderer.JRendererLabel;
import org.shiftone.jrat.depends.jdesktop.swingx.renderer.LabelProvider;
import org.shiftone.jrat.depends.jdesktop.swingx.renderer.StringValue;

public class TreeLabelProvider
extends LabelProvider {
    boolean selected;
    boolean hasFocus;
    Color treeSelectionBackground;
    Color treeBackground;
    private boolean drawsFocusBorderAroundIcon;
    private boolean drawDashedFocusIndicator;
    private Color borderSelectionColor;

    public TreeLabelProvider() {
        this(null);
    }

    public TreeLabelProvider(StringValue converter) {
        super(converter);
        Object value = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = value != null && (Boolean)value != false;
        value = UIManager.get("Tree.drawDashedFocusIndicator");
        this.drawDashedFocusIndicator = value != null && (Boolean)value != false;
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
    }

    private void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    protected void configureState(CellContext context) {
        super.configureState(context);
        this.configureIcon(context);
        this.configureBorder(context);
        this.selected = context.isSelected();
        this.hasFocus = context.isFocused();
    }

    protected void configureBorder(CellContext context) {
        ((JLabel)this.rendererComponent).setBorder(null);
    }

    protected void configureIcon(CellContext context) {
        if (((Component)context.getComponent()).isEnabled()) {
            ((JLabel)this.rendererComponent).setIcon(this.getIcon(context));
        } else {
            ((JLabel)this.rendererComponent).setDisabledIcon(context.getIcon());
        }
    }

    protected Icon getIcon(CellContext context) {
        return context.getIcon();
    }

    protected JLabel createRendererComponent() {
        return new TreeRendererLabel();
    }

    class TreeRendererLabel
    extends JRendererLabel {
        private Color focusBGColor;

        TreeRendererLabel() {
            this.setOpaque(false);
        }

        public void paint(Graphics g) {
            Color bColor = this.getBackground();
            int imageOffset = -1;
            if (bColor != null) {
                imageOffset = this.getLabelStart();
                g.setColor(bColor);
                if (this.getComponentOrientation().isLeftToRight()) {
                    g.fillRect(imageOffset, 0, this.getWidth() - imageOffset, this.getHeight());
                } else {
                    g.fillRect(0, 0, this.getWidth() - imageOffset, this.getHeight());
                }
            }
            if (TreeLabelProvider.this.hasFocus) {
                if (TreeLabelProvider.this.drawsFocusBorderAroundIcon) {
                    imageOffset = 0;
                } else if (imageOffset == -1) {
                    imageOffset = this.getLabelStart();
                }
                if (this.getComponentOrientation().isLeftToRight()) {
                    this.paintFocus(g, imageOffset, 0, this.getWidth() - imageOffset, this.getHeight());
                } else {
                    this.paintFocus(g, 0, 0, this.getWidth() - imageOffset, this.getHeight());
                }
            }
            super.paint(g);
        }

        private void paintFocus(Graphics g, int x, int y, int w, int h) {
            Color bsColor = TreeLabelProvider.this.borderSelectionColor;
            if (bsColor != null && (TreeLabelProvider.this.selected || !TreeLabelProvider.this.drawDashedFocusIndicator)) {
                g.setColor(bsColor);
                g.drawRect(x, y, w - 1, h - 1);
            }
            if (TreeLabelProvider.this.drawDashedFocusIndicator) {
                Color color = this.getBackground();
                if (TreeLabelProvider.this.treeBackground != color) {
                    TreeLabelProvider.this.treeBackground = color;
                    this.focusBGColor = new Color(~color.getRGB());
                }
                g.setColor(this.focusBGColor);
                BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
            }
        }

        private int getLabelStart() {
            Icon currentI = this.getIcon();
            if (currentI != null && this.getText() != null) {
                return currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
            }
            return 0;
        }

        public Dimension getPreferredSize() {
            Dimension retDimension = super.getPreferredSize();
            if (retDimension != null) {
                retDimension = new Dimension(retDimension.width + 3, retDimension.height);
            }
            return retDimension;
        }
    }
}

