/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.treetable;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.tree.TreePath;
import org.shiftone.jrat.depends.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.shiftone.jrat.depends.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.shiftone.jrat.depends.jdesktop.swingx.treetable.TreeTableNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeTableModel
extends AbstractTreeTableModel {
    protected Vector columnIdentifiers;
    private boolean useAutoCalculatedIdentifiers;

    public DefaultTreeTableModel() {
        this(null);
    }

    public DefaultTreeTableModel(TreeTableNode root) {
        this(root, null);
    }

    public DefaultTreeTableModel(TreeTableNode root, Vector columnNames) {
        super(root);
        this.setColumnIdentifiers(columnNames);
    }

    private boolean isValidTreeTableNode(Object node) {
        boolean result = false;
        if (node instanceof TreeTableNode) {
            for (TreeTableNode ttn = (TreeTableNode)node; !result && ttn != null; ttn = ttn.getParent()) {
                result = ttn == this.root;
            }
        }
        return result;
    }

    public void setColumnIdentifiers(Vector columnIdentifiers) {
        this.useAutoCalculatedIdentifiers = columnIdentifiers == null;
        this.columnIdentifiers = this.useAutoCalculatedIdentifiers ? DefaultTreeTableModel.getAutoCalculatedIdentifiers(this.getRoot()) : columnIdentifiers;
    }

    private static Vector<String> getAutoCalculatedIdentifiers(TreeTableNode exemplar) {
        Vector<String> autoCalculatedIndentifiers = new Vector<String>();
        if (exemplar != null) {
            int len = exemplar.getColumnCount();
            for (int i = 0; i < len; ++i) {
                autoCalculatedIndentifiers.add(null);
            }
        }
        return autoCalculatedIndentifiers;
    }

    @Override
    public TreeTableNode getRoot() {
        return (TreeTableNode)this.root;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        if (!this.isValidTreeTableNode(node)) {
            throw new IllegalArgumentException("node must be a valid node managed by this model");
        }
        if (column < 0 || column >= this.getColumnCount()) {
            throw new IllegalArgumentException("column must be a valid index");
        }
        return ((TreeTableNode)node).getValueAt(column);
    }

    @Override
    public void setValueAt(Object value, Object node, int column) {
        if (!this.isValidTreeTableNode(node)) {
            throw new IllegalArgumentException("node must be a valid node managed by this model");
        }
        if (column < 0 || column >= this.getColumnCount()) {
            throw new IllegalArgumentException("column must be a valid index");
        }
        TreeTableNode ttn = (TreeTableNode)node;
        if (column < ttn.getColumnCount()) {
            ttn.setValueAt(value, column);
            this.modelSupport.firePathChanged(new TreePath(this.getPathToRoot(ttn)));
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    @Override
    public String getColumnName(int column) {
        Object id = null;
        if (column < this.columnIdentifiers.size() && column >= 0) {
            id = this.columnIdentifiers.elementAt(column);
        }
        return id == null ? super.getColumnName(column) : id.toString();
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (!this.isValidTreeTableNode(parent)) {
            throw new IllegalArgumentException("parent must be a TreeTableNode managed by this model");
        }
        return ((TreeTableNode)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (!this.isValidTreeTableNode(parent)) {
            throw new IllegalArgumentException("parent must be a TreeTableNode managed by this model");
        }
        return ((TreeTableNode)parent).getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (!this.isValidTreeTableNode(parent)) {
            throw new IllegalArgumentException("parent must be a TreeTableNode managed by this model");
        }
        if (!this.isValidTreeTableNode(parent)) {
            throw new IllegalArgumentException("child must be a TreeTableNode managed by this model");
        }
        return ((TreeTableNode)parent).getIndex((TreeTableNode)child);
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        if (!this.isValidTreeTableNode(node)) {
            throw new IllegalArgumentException("node must be a valid node managed by this model");
        }
        if (column < 0 || column >= this.getColumnCount()) {
            throw new IllegalArgumentException("column must be a valid index");
        }
        TreeTableNode ttn = (TreeTableNode)node;
        if (column >= ttn.getColumnCount()) {
            return false;
        }
        return ttn.isEditable(column);
    }

    @Override
    public boolean isLeaf(Object node) {
        if (!this.isValidTreeTableNode(node)) {
            throw new IllegalArgumentException("node must be a TreeTableNode managed by this model");
        }
        return ((TreeTableNode)node).isLeaf();
    }

    public TreeTableNode[] getPathToRoot(TreeTableNode aNode) {
        TreeTableNode node;
        ArrayList<TreeTableNode> path = new ArrayList<TreeTableNode>();
        for (node = aNode; node != this.root; node = node.getParent()) {
            path.add(0, node);
        }
        if (node == this.root) {
            path.add(0, node);
        }
        return path.toArray(new TreeTableNode[0]);
    }

    public void setRoot(TreeTableNode root) {
        this.root = root;
        if (this.useAutoCalculatedIdentifiers) {
            this.setColumnIdentifiers(null);
        }
        this.modelSupport.fireNewRoot();
    }

    public void insertNodeInto(MutableTreeTableNode newChild, MutableTreeTableNode parent, int index) {
        parent.insert(newChild, index);
        this.modelSupport.fireChildAdded(new TreePath(this.getPathToRoot(parent)), index, newChild);
    }

    public void removeNodeFromParent(MutableTreeTableNode node) {
        MutableTreeTableNode parent = (MutableTreeTableNode)node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int index = parent.getIndex(node);
        node.removeFromParent();
        this.modelSupport.fireChildRemoved(new TreePath(this.getPathToRoot(parent)), index, node);
    }
}

