/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.treetable;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class TreeModelSupport {
    protected EventListenerList listeners;
    private TreeModel treeModel;

    public TreeModelSupport(TreeModel model) {
        if (model == null) {
            throw new NullPointerException("model must not be null");
        }
        this.listeners = new EventListenerList();
        this.treeModel = model;
    }

    public void fireNewRoot() {
        Object[] pairs = this.listeners.getListenerList();
        Object root = this.treeModel.getRoot();
        TreePath path = root != null ? new TreePath(root) : null;
        TreeModelEvent e = null;
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = this.createTreeModelEvent(path);
            }
            ((TreeModelListener)pairs[i + 1]).treeStructureChanged(e);
        }
    }

    public void fireStructureChanged() {
        this.fireTreeStructureChanged(new TreePath(this.treeModel.getRoot()));
    }

    public void firePathLeafStateChanged(TreePath path) {
        this.fireTreeStructureChanged(path);
    }

    public void fireTreeStructureChanged(TreePath parentPath) {
        Object[] pairs = this.listeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = this.createTreeModelEvent(parentPath);
            }
            ((TreeModelListener)pairs[i + 1]).treeStructureChanged(e);
        }
    }

    public void firePathChanged(TreePath path) {
        Object node = path.getLastPathComponent();
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            this.fireChildrenChanged(path, null, null);
        } else {
            Object parent = parentPath.getLastPathComponent();
            this.fireChildChanged(parentPath, this.treeModel.getIndexOfChild(parent, node), node);
        }
    }

    public void fireChildAdded(TreePath parentPath, int index, Object child) {
        this.fireChildrenAdded(parentPath, new int[]{index}, new Object[]{child});
    }

    public void fireChildChanged(TreePath parentPath, int index, Object child) {
        this.fireChildrenChanged(parentPath, new int[]{index}, new Object[]{child});
    }

    public void fireChildRemoved(TreePath parentPath, int index, Object child) {
        this.fireChildrenRemoved(parentPath, new int[]{index}, new Object[]{child});
    }

    public void fireChildrenAdded(TreePath parentPath, int[] indices, Object[] children) {
        Object[] pairs = this.listeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = this.createTreeModelEvent(parentPath, indices, children);
            }
            ((TreeModelListener)pairs[i + 1]).treeNodesInserted(e);
        }
    }

    private TreeModelEvent createTreeModelEvent(TreePath parentPath) {
        return this.createTreeModelEvent(parentPath, null, null);
    }

    private TreeModelEvent createTreeModelEvent(TreePath parentPath, int[] indices, Object[] children) {
        return new TreeModelEvent((Object)this.treeModel, parentPath, indices, children);
    }

    public void fireChildrenChanged(TreePath parentPath, int[] indices, Object[] children) {
        Object[] pairs = this.listeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = this.createTreeModelEvent(parentPath, indices, children);
            }
            ((TreeModelListener)pairs[i + 1]).treeNodesChanged(e);
        }
    }

    public void fireChildrenRemoved(TreePath parentPath, int[] indices, Object[] children) {
        Object[] pairs = this.listeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = this.createTreeModelEvent(parentPath, indices, children);
            }
            ((TreeModelListener)pairs[i + 1]).treeNodesRemoved(e);
        }
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(TreeModelListener.class, l);
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(TreeModelListener.class, l);
    }
}

