/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class PaintUtils {
    private static GraphicsConfiguration configuration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    private static Border defaultBorder = BorderFactory.createBevelBorder(0);
    public static final GradientPaint BLUE_EXPERIENCE = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(168, 204, 241), new Point2D.Double(0.0, 1.0), new Color(44, 61, 146));
    public static final GradientPaint MAC_OSX_SELECTED = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(81, 141, 236), new Point2D.Double(0.0, 1.0), new Color(36, 96, 192));
    public static final GradientPaint MAC_OSX = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(167, 210, 250), new Point2D.Double(0.0, 1.0), new Color(99, 147, 206));
    public static final GradientPaint AERITH = new GradientPaint(new Point2D.Double(0.0, 0.0), Color.WHITE, new Point2D.Double(0.0, 1.0), new Color(64, 110, 161));
    public static final GradientPaint GRAY = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(226, 226, 226), new Point2D.Double(0.0, 1.0), new Color(250, 248, 248));
    public static final GradientPaint RED_XP = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(236, 81, 81), new Point2D.Double(0.0, 1.0), new Color(192, 36, 36));
    public static final GradientPaint NIGHT_GRAY = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(102, 111, 127), new Point2D.Double(0.0, 1.0), new Color(38, 45, 61));
    public static final GradientPaint NIGHT_GRAY_LIGHT = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(129, 138, 155), new Point2D.Double(0.0, 1.0), new Color(58, 66, 82));

    private PaintUtils() {
    }

    public static Border getDefaultBorder() {
        return defaultBorder;
    }

    public static Rectangle getTextBounds(Graphics g, JLabel label) {
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D r2d = fm.getStringBounds(label.getText(), g);
        Rectangle rect = r2d.getBounds();
        int xOffset = 0;
        switch (label.getHorizontalAlignment()) {
            case 4: 
            case 11: {
                xOffset = label.getBounds().width - rect.width;
                break;
            }
            case 0: {
                xOffset = (label.getBounds().width - rect.width) / 2;
                break;
            }
            default: {
                xOffset = 0;
            }
        }
        int yOffset = 0;
        switch (label.getVerticalAlignment()) {
            case 1: {
                yOffset = 0;
                break;
            }
            case 0: {
                yOffset = (label.getBounds().height - rect.height) / 2;
                break;
            }
            case 3: {
                yOffset = label.getBounds().height - rect.height;
            }
        }
        return new Rectangle(xOffset, yOffset, rect.width, rect.height);
    }

    public static void paintGradient(Graphics g, JComponent comp, Color color1, Color color2) {
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, color1, 0.0f, comp.getHeight(), color2, true);
        Graphics2D g2 = (Graphics2D)g;
        Paint oldPaint = g2.getPaint();
        g2.setPaint(paint);
        g2.fillRect(0, 0, comp.getWidth(), comp.getHeight());
        g2.setPaint(oldPaint);
    }

    public static void setBackgroundColor(Container cont, Color color) {
        Component[] children;
        cont.setBackground(color);
        for (Component aChildren : children = cont.getComponents()) {
            if (aChildren instanceof Container) {
                PaintUtils.setBackgroundColor((Container)aChildren, color);
                continue;
            }
            aChildren.setBackground(color);
        }
    }

    public static void setForegroundColor(Container cont, Color color) {
        Component[] children;
        cont.setForeground(color);
        for (Component aChildren : children = cont.getComponents()) {
            if (aChildren instanceof Container) {
                PaintUtils.setForegroundColor((Container)aChildren, color);
                continue;
            }
            aChildren.setForeground(color);
        }
    }

    public static void setFont(Container cont, Font font) {
        Component[] children;
        cont.setFont(font);
        for (Component aChildren : children = cont.getComponents()) {
            if (aChildren instanceof Container) {
                PaintUtils.setFont((Container)aChildren, font);
                continue;
            }
            aChildren.setFont(font);
        }
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice screenDevice = environment.getDefaultScreenDevice();
        GraphicsConfiguration configuration = screenDevice.getDefaultConfiguration();
        return configuration.createCompatibleImage(width, height);
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice screenDevice = environment.getDefaultScreenDevice();
        GraphicsConfiguration configuration = screenDevice.getDefaultConfiguration();
        return configuration.createCompatibleImage(width, height, transparency);
    }

    public static BufferedImage convertToBufferedImage(Image img) {
        BufferedImage buff = PaintUtils.createCompatibleImage(img.getWidth(null), img.getHeight(null));
        Graphics2D g2 = buff.createGraphics();
        g2.drawImage(img, 0, 0, null);
        g2.dispose();
        return buff;
    }

    public static BufferedImage loadCompatibleImage(URL resource) throws IOException {
        BufferedImage image = ImageIO.read(resource);
        if (image == null) {
            return null;
        }
        return PaintUtils.toCompatibleImage(image);
    }

    public static BufferedImage loadCompatibleImage(InputStream in) throws IOException {
        BufferedImage image = ImageIO.read(in);
        if (image == null) {
            return null;
        }
        return PaintUtils.toCompatibleImage(image);
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        BufferedImage compatibleImage = configuration.createCompatibleImage(image.getWidth(), image.getHeight(), 3);
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    public static Shape setMergedClip(Graphics2D g, Shape newClip) {
        Shape oldClip = g.getClip();
        if (oldClip == null) {
            g.setClip(newClip);
            return null;
        }
        Area area = new Area(oldClip);
        area.intersect(new Area(newClip));
        g.setClip(area);
        return oldClip;
    }

    public static Paint resizeGradient(Paint p, int width, int height) {
        if (p == null) {
            return p;
        }
        if (p instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)p;
            Point2D start = gp.getPoint1();
            Point2D end = gp.getPoint2();
            Point2D[] pts = new Point2D[]{gp.getPoint1(), gp.getPoint2()};
            pts = PaintUtils.adjustPoints(pts, width, height);
            return new GradientPaint(pts[0], gp.getColor1(), pts[1], gp.getColor2(), gp.isCyclic());
        }
        if ("java.awt.LinearGradientPaint".equals(p.getClass().getName()) || "org.apache.batik.ext.awt.LinearGradientPaint".equals(p.getClass().getName())) {
            return PaintUtils.resizeLinearGradient(p, width, height);
        }
        return p;
    }

    private static Paint resizeLinearGradient(Paint p, int width, int height) {
        try {
            Point2D[] pts = new Point2D[]{(Point2D)PaintUtils.invokeMethod(p, "getStartPoint"), (Point2D)PaintUtils.invokeMethod(p, "getEndPoint")};
            pts = PaintUtils.adjustPoints(pts, width, height);
            float[] fractions = (float[])PaintUtils.invokeMethod(p, "getFractions");
            Color[] colors = (Color[])PaintUtils.invokeMethod(p, "getColors");
            Constructor<?> con = p.getClass().getDeclaredConstructor(Point2D.class, Point2D.class, new float[0].getClass(), new Color[0].getClass());
            return (Paint)con.newInstance(pts[0], pts[1], fractions, colors);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return p;
        }
    }

    private static Object invokeMethod(Object p, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalArgumentException, SecurityException, IllegalAccessException {
        Method meth = p.getClass().getMethod(methodName, new Class[0]);
        return meth.invoke(p, null);
    }

    private static Point2D[] adjustPoints(Point2D[] pts, int width, int height) {
        Point2D start = pts[0];
        Point2D end = pts[1];
        double angle = PaintUtils.calcAngle(start, end);
        double a2 = Math.toDegrees(angle);
        double e = 1.0;
        if (Math.abs(angle) < Math.toRadians(e) || Math.abs(angle) > Math.toRadians(360.0 - e)) {
            start = new Point2D.Float(0.0f, 0.0f);
            end = new Point2D.Float(width, 0.0f);
        }
        if (PaintUtils.isNear(a2, 45.0, e)) {
            start = new Point2D.Float(0.0f, 0.0f);
            end = new Point2D.Float(width, height);
        }
        if (PaintUtils.isNear(a2, 90.0, e)) {
            start = new Point2D.Float(0.0f, 0.0f);
            end = new Point2D.Float(0.0f, height);
        }
        if (PaintUtils.isNear(a2, 135.0, e)) {
            start = new Point2D.Float(width, 0.0f);
            end = new Point2D.Float(0.0f, height);
        }
        if (PaintUtils.isNear(a2, 180.0, e)) {
            start = new Point2D.Float(width, 0.0f);
            end = new Point2D.Float(0.0f, 0.0f);
        }
        if (PaintUtils.isNear(a2, 225.0, e)) {
            start = new Point2D.Float(width, height);
            end = new Point2D.Float(0.0f, 0.0f);
        }
        if (PaintUtils.isNear(a2, 270.0, e)) {
            start = new Point2D.Float(0.0f, height);
            end = new Point2D.Float(0.0f, 0.0f);
        }
        if (PaintUtils.isNear(a2, 315.0, e)) {
            start = new Point2D.Float(0.0f, height);
            end = new Point2D.Float(width, 0.0f);
        }
        return new Point2D[]{start, end};
    }

    private static boolean isNear(double angle, double target, double error) {
        return Math.abs(target - Math.abs(angle)) < error;
    }

    private static double calcAngle(Point2D p1, Point2D p2) {
        double x_off = p2.getX() - p1.getX();
        double y_off = p2.getY() - p1.getY();
        double angle = Math.atan(y_off / x_off);
        if (x_off < 0.0) {
            angle += Math.PI;
        }
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        if (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        return angle;
    }

    private static void p(String string) {
        System.out.println(string);
    }
}

