/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JTabbedPane;
import org.shiftone.jrat.depends.jdesktop.swingx.JXStatusBar;
import org.shiftone.jrat.desktop.DesktopPreferences;
import org.shiftone.jrat.desktop.Memory;
import org.shiftone.jrat.desktop.TabMouseListener;
import org.shiftone.jrat.desktop.action.file.ClearPreferencesAction;
import org.shiftone.jrat.desktop.action.file.CloseAction;
import org.shiftone.jrat.desktop.action.file.CloseAllAction;
import org.shiftone.jrat.desktop.action.file.ExitAction;
import org.shiftone.jrat.desktop.action.file.OpenAction;
import org.shiftone.jrat.desktop.action.file.WindowSizeAction;
import org.shiftone.jrat.desktop.action.help.AboutAction;
import org.shiftone.jrat.desktop.action.help.DocsAction;
import org.shiftone.jrat.desktop.action.help.TipsAction;
import org.shiftone.jrat.desktop.action.inject.InjectDirectoryAction;
import org.shiftone.jrat.desktop.action.inject.InjectFileAction;
import org.shiftone.jrat.util.log.Logger;

public class DesktopFrame
extends JFrame {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$desktop$DesktopFrame == null ? (class$org$shiftone$jrat$desktop$DesktopFrame = DesktopFrame.class$("org.shiftone.jrat.desktop.DesktopFrame")) : class$org$shiftone$jrat$desktop$DesktopFrame);
    private JXStatusBar statusBar = DesktopFrame.createStatusBar();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private CloseAction closeAction = new CloseAction(this.tabbedPane);
    private CloseAllAction closeAllAction = new CloseAllAction(this.tabbedPane);
    private OpenAction openAction = new OpenAction(this);
    private int waiters = 0;
    static /* synthetic */ Class class$org$shiftone$jrat$desktop$DesktopFrame;

    public DesktopFrame() {
        super("JRat Desktop");
        DesktopPreferences.setLastRunTime(System.currentTimeMillis());
        DesktopPreferences.incrementRunCount();
        this.setDefaultCloseOperation(3);
        Rectangle windowBounds = DesktopPreferences.getWindowBounds();
        if (windowBounds == null) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            windowBounds = new Rectangle(50, 50, (int)dimension.getWidth() - 150, (int)dimension.getHeight() - 150);
        }
        this.setBounds(windowBounds);
        this.setJMenuBar(this.createMenuBar());
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.add((Component)this.tabbedPane, "Center");
        pane.add((Component)this.statusBar, "South");
        this.tabbedPane.addMouseListener(new TabMouseListener(this.tabbedPane));
        this.tabbedPane.addContainerListener(new TabChangeListener());
        this.checkTabs();
        this.addComponentListener(new ComponentListener());
    }

    public void waitCursor() {
        ++this.waiters;
        this.setCursor(3);
    }

    public void unwaitCursor() {
        --this.waiters;
        if (this.waiters == 0) {
            this.setCursor(0);
        }
    }

    private JMenuBar createMenuBar() {
        JMenuBar toolBar = new JMenuBar();
        JMenu file = new JMenu("File");
        file.setMnemonic('F');
        file.add(this.openAction);
        file.add(this.closeAction);
        file.add(this.closeAllAction);
        JMenu resize = new JMenu("Window Size");
        resize.setMnemonic('S');
        resize.add(new WindowSizeAction(this, 640, 480));
        resize.add(new WindowSizeAction(this, 800, 600));
        resize.add(new WindowSizeAction(this, 1024, 768));
        file.add(resize);
        file.add(new ExitAction());
        file.add(new ClearPreferencesAction(this));
        toolBar.add(file);
        JMenu inject = new JMenu("Inject");
        inject.setMnemonic('I');
        inject.add(new InjectDirectoryAction(this));
        inject.add(new InjectFileAction(this));
        toolBar.add(inject);
        JMenu help = new JMenu("Help");
        help.setMnemonic('H');
        help.add(new AboutAction(this));
        help.add(new DocsAction(this));
        help.add(new TipsAction(this));
        toolBar.add(help);
        return toolBar;
    }

    void open(String name, InputStream inputStream) {
        this.openAction.open(name, inputStream);
    }

    public static JXStatusBar createStatusBar() {
        JXStatusBar statusBar = new JXStatusBar();
        statusBar.setLayout(new BorderLayout());
        statusBar.add((Component)Memory.createMemoryButton(), "East");
        return statusBar;
    }

    public void createView(String title, JComponent component) {
        this.tabbedPane.addTab(title, component);
        this.tabbedPane.setSelectedComponent(component);
    }

    private void checkTabs() {
        boolean enableClose = this.tabbedPane.getTabCount() > 0;
        this.closeAction.setEnabled(enableClose);
        this.closeAllAction.setEnabled(enableClose);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TabChangeListener
    implements ContainerListener {
        private TabChangeListener() {
        }

        public void componentAdded(ContainerEvent e) {
            DesktopFrame.this.checkTabs();
        }

        public void componentRemoved(ContainerEvent e) {
            DesktopFrame.this.checkTabs();
        }
    }

    private class ComponentListener
    extends ComponentAdapter {
        private ComponentListener() {
        }

        public void componentResized(ComponentEvent e) {
            DesktopPreferences.setWindowBounds(DesktopFrame.this.getBounds());
        }

        public void componentMoved(ComponentEvent e) {
            DesktopPreferences.setWindowBounds(DesktopFrame.this.getBounds());
        }
    }
}

