/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.desktop;

import java.awt.Rectangle;
import java.io.File;
import java.util.prefs.Preferences;
import org.shiftone.jrat.util.StringUtil;

public class DesktopPreferences {
    private static final Preferences PREFS = Preferences.userNodeForPackage(class$org$shiftone$jrat$desktop$DesktopPreferences == null ? (class$org$shiftone$jrat$desktop$DesktopPreferences = DesktopPreferences.class$("org.shiftone.jrat.desktop.DesktopPreferences")) : class$org$shiftone$jrat$desktop$DesktopPreferences);
    private static final String RUN_COUNT = "run_count";
    private static final String TIPS_ON_START = "show_tips_on_startup";
    private static final String LAST_RUN_TIME = "last_run_time";
    private static final String LAST_OPENED_FILE = "last_opened_file";
    private static final String WINDOW_BOUNDS = "window_bounds";
    private static final String LAST_INJECTED_FILE = "last_injected_file";
    private static final String LAST_INJECTED_DIR = "last_injected_dir";
    static /* synthetic */ Class class$org$shiftone$jrat$desktop$DesktopPreferences;

    public static int getRunCount() {
        return PREFS.getInt(RUN_COUNT, 0);
    }

    public static void setRunCount(int runCount) {
        PREFS.putInt(RUN_COUNT, runCount);
    }

    public static void incrementRunCount() {
        DesktopPreferences.setRunCount(DesktopPreferences.getRunCount() + 1);
    }

    public static boolean isShowTipsOnStartup() {
        return PREFS.getBoolean(TIPS_ON_START, true);
    }

    public static void setShowTipsOnStartup(boolean showTipsOnStartup) {
        PREFS.putBoolean(TIPS_ON_START, showTipsOnStartup);
    }

    public static long getLastRunTime() {
        return PREFS.getLong(LAST_RUN_TIME, 0L);
    }

    public static void setLastRunTime(long lastRunTime) {
        PREFS.putLong(LAST_RUN_TIME, lastRunTime);
    }

    public static Rectangle getWindowBounds() {
        String text = PREFS.get(WINDOW_BOUNDS, null);
        if (text != null) {
            String[] values = StringUtil.tokenize(text, ",", false);
            return new Rectangle(Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]), Integer.parseInt(values[3]));
        }
        return null;
    }

    public static void setWindowBounds(Rectangle bounds) {
        PREFS.put(WINDOW_BOUNDS, bounds.x + "," + bounds.y + "," + bounds.width + "," + bounds.height);
    }

    public static File getLastOpenedFile() {
        return DesktopPreferences.getFile(LAST_OPENED_FILE);
    }

    public static void setLastOpenedFile(File file) {
        DesktopPreferences.setFile(LAST_OPENED_FILE, file);
    }

    public static File getLastInjectedFile() {
        return DesktopPreferences.getFile(LAST_INJECTED_FILE);
    }

    public static void setLastInjectedFile(File file) {
        DesktopPreferences.setFile(LAST_INJECTED_FILE, file);
    }

    public static File getLastInjectedDir() {
        return DesktopPreferences.getFile(LAST_INJECTED_DIR);
    }

    public static void setLastInjectedDir(File file) {
        DesktopPreferences.setFile(LAST_INJECTED_DIR, file);
    }

    private static File getFile(String key) {
        String name = PREFS.get(key, null);
        return name == null ? null : new File(name);
    }

    private static void setFile(String key, File value) {
        PREFS.put(key, value == null ? null : value.getAbsolutePath());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

