/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.desktop;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.shiftone.jrat.depends.jdesktop.swingx.JXHyperlink;

public class Memory
extends JPanel {
    private static final long MEG = 0x100000L;
    private static final Timer timer = new Timer(true);

    public static JButton createMemoryButton() {
        JXHyperlink button = new JXHyperlink();
        button.addActionListener(new GcAction());
        timer.schedule((TimerTask)new TickerTask(button), 1000L, 1000L);
        return button;
    }

    private static String toMeg(long bytes) {
        return (int)((double)bytes / 1048576.0) + "M";
    }

    private static class TickerTask
    extends TimerTask {
        private final JButton button;

        public TickerTask(JButton button) {
            this.button = button;
        }

        public void run() {
            Runtime runtime = Runtime.getRuntime();
            final StringBuffer sb = new StringBuffer();
            long total = runtime.totalMemory();
            long max = runtime.maxMemory();
            long free = runtime.freeMemory();
            sb.append(Memory.toMeg(total - free));
            sb.append(" of ");
            sb.append(Memory.toMeg(max));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TickerTask.this.button.setText(sb.toString());
                }
            });
        }
    }

    private static class GcAction
    implements ActionListener {
        private GcAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.gc();
        }
    }
}

