/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import org.shiftone.jrat.util.Assert;

public class TabMouseListener
extends MouseAdapter
implements ActionListener {
    private JMenuItem newWindowMenuItem = new JMenuItem("New Window");
    private JMenuItem closeMenuItem = new JMenuItem("Close");
    private JMenuItem closeAllButMenuItem = new JMenuItem("Close All But This");
    private JMenuItem closeAllMenuItem = new JMenuItem("Close All");
    protected JPopupMenu popup = new JPopupMenu();
    protected JTabbedPane tabPane = null;
    protected int index = -1;

    public TabMouseListener(JTabbedPane tabPane) {
        Assert.assertNotNull(tabPane);
        this.tabPane = tabPane;
        this.popup.add(this.newWindowMenuItem);
        this.popup.add(this.closeMenuItem);
        this.popup.add(this.closeAllButMenuItem);
        this.popup.add(this.closeAllMenuItem);
        this.newWindowMenuItem.addActionListener(this);
        this.closeMenuItem.addActionListener(this);
        this.closeAllButMenuItem.addActionListener(this);
        this.closeAllMenuItem.addActionListener(this);
    }

    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.index = this.tabPane.indexAtLocation(e.getX(), e.getY());
            if (this.index != -1) {
                this.tabPane.setSelectedIndex(this.index);
                this.preShow();
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    protected void preShow() {
        this.closeMenuItem.setEnabled(true);
        this.closeAllMenuItem.setEnabled(true);
        this.newWindowMenuItem.setEnabled(true);
        if (this.tabPane.getTabCount() == 1) {
            this.closeAllButMenuItem.setEnabled(false);
        } else {
            this.closeAllButMenuItem.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeMenuItem) {
            this.tabPane.remove(this.index);
        } else if (e.getSource() == this.closeAllButMenuItem) {
            this.closeAll(false);
        } else if (e.getSource() == this.closeAllMenuItem) {
            this.closeAll(true);
        } else if (e.getSource() == this.newWindowMenuItem) {
            this.spawn();
        }
    }

    public void spawn() {
        Component component = this.tabPane.getComponentAt(this.index);
        String title = this.tabPane.getTitleAt(this.index);
        this.tabPane.remove(component);
        SpawnedFrame frame = new SpawnedFrame(title, component);
        frame.setSize(this.tabPane.getSize());
        frame.setLocation(this.tabPane.getLocationOnScreen());
        frame.setVisible(true);
    }

    public void closeAll(boolean includeIndex) {
        for (int i = this.tabPane.getTabCount() - 1; i >= 0; --i) {
            if (!includeIndex && i == this.index) continue;
            this.tabPane.remove(i);
        }
    }

    private class SpawnedFrame
    extends JFrame {
        private final String title;
        private final Component component;

        public SpawnedFrame(String title, Component component) throws HeadlessException {
            super(title);
            this.title = title;
            this.component = component;
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add(component, "Center");
            this.addWindowListener(new CloseAdapter());
        }

        private class CloseAdapter
        extends WindowAdapter {
            private CloseAdapter() {
            }

            public void windowClosing(WindowEvent windowEvent) {
                SpawnedFrame.this.getContentPane().removeAll();
                ((SpawnedFrame)SpawnedFrame.this).TabMouseListener.this.tabPane.addTab(SpawnedFrame.this.title, SpawnedFrame.this.component);
            }
        }
    }
}

