/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.desktop.action.file;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.zip.GZIPInputStream;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.shiftone.jrat.core.spi.ViewBuilder;
import org.shiftone.jrat.desktop.DesktopFrame;
import org.shiftone.jrat.desktop.DesktopPreferences;
import org.shiftone.jrat.desktop.util.Errors;
import org.shiftone.jrat.util.io.IOUtil;
import org.shiftone.jrat.util.log.Logger;

public class OpenAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$desktop$action$file$OpenAction == null ? (class$org$shiftone$jrat$desktop$action$file$OpenAction = OpenAction.class$("org.shiftone.jrat.desktop.action.file.OpenAction")) : class$org$shiftone$jrat$desktop$action$file$OpenAction);
    private final DesktopFrame desktopFrame;
    static /* synthetic */ Class class$org$shiftone$jrat$desktop$action$file$OpenAction;

    public OpenAction(DesktopFrame desktopFrame) {
        super("Open");
        this.desktopFrame = desktopFrame;
        this.putValue("MnemonicKey", new Integer(79));
    }

    private File getCurrentDirectory() {
        File file = DesktopPreferences.getLastOpenedFile();
        return file != null ? IOUtil.getNearestExistingParent(file) : new File("");
    }

    private File getSelectedFile() {
        File file = DesktopPreferences.getLastOpenedFile();
        return file != null && file.exists() ? file : null;
    }

    private File getParent(File file) {
        File parent = file.getParentFile();
        if (parent.exists()) {
            return parent;
        }
        return this.getParent(parent);
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Open JRat Output File");
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setCurrentDirectory(this.getCurrentDirectory());
        chooser.setSelectedFile(this.getSelectedFile());
        chooser.addChoosableFileFilter(JRatFileFilter.INSTANCE);
        if (0 == chooser.showOpenDialog(this.desktopFrame)) {
            this.openFiles(chooser.getSelectedFiles());
        }
    }

    private void openFiles(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            this.openFile(files[i]);
        }
    }

    private void openFile(File file) {
        DesktopPreferences.setLastOpenedFile(file);
        new Thread(new OpenRunnable(file)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String name, InputStream inputStream) {
        try {
            this.desktopFrame.waitCursor();
            inputStream = new GZIPInputStream(inputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            ViewBuilder viewBuilder = (ViewBuilder)objectInputStream.readObject();
            JComponent component = viewBuilder.buildView(objectInputStream);
            this.desktopFrame.createView(name, component);
        }
        catch (OutOfMemoryError e) {
            Errors.showError(this.desktopFrame, e, "Out of Memory!  Use the -Xmx Java option.");
        }
        catch (Exception e) {
            Errors.showError(this.desktopFrame, e, "Failed to open : " + name);
        }
        finally {
            this.desktopFrame.unwaitCursor();
            IOUtil.close(inputStream);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class JRatFileFilter
    extends FileFilter {
        static FileFilter INSTANCE = new JRatFileFilter();

        private JRatFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(".jrat");
        }

        public String getDescription() {
            return "JRat Data File (*.jrat)";
        }
    }

    private class OpenRunnable
    implements Runnable {
        private final File file;

        public OpenRunnable(File file) {
            this.file = file;
        }

        public void run() {
            OpenAction.this.open(this.file.getName(), IOUtil.openInputStream(this.file));
        }
    }
}

