/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.desktop.action.inject;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.shiftone.jrat.util.Exceptions;
import org.shiftone.jrat.util.log.Constants;
import org.shiftone.jrat.util.log.Logger;
import org.shiftone.jrat.util.log.LoggerFactory;
import org.shiftone.jrat.util.log.target.LogTarget;

public class RunnableLogPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$desktop$action$inject$RunnableLogPanel == null ? (class$org$shiftone$jrat$desktop$action$inject$RunnableLogPanel = RunnableLogPanel.class$("org.shiftone.jrat.desktop.action.inject.RunnableLogPanel")) : class$org$shiftone$jrat$desktop$action$inject$RunnableLogPanel);
    private JLabel label;
    private Thread thread;
    private JTextArea textArea = new JTextArea();
    private JScrollPane scrollPane = new JScrollPane(this.textArea);
    private Document document = this.textArea.getDocument();
    private int textOffset = 0;
    private BoundedRangeModel scrollBarRangeModel = this.scrollPane.getVerticalScrollBar().getModel();
    static /* synthetic */ Class class$org$shiftone$jrat$desktop$action$inject$RunnableLogPanel;

    public RunnableLogPanel() {
        this.label = new JLabel();
        this.textArea.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "North");
        this.add((Component)this.scrollPane, "Center");
    }

    public synchronized void run(final Runnable target) {
        Runnable runnable = new Runnable(){

            public void run() {
                RunnableLogPanel.this.setLabel("Running...");
                try {
                    LoggerFactory.executeInThreadScope(new GuiLogTarget(), target);
                    RunnableLogPanel.this.setLabel("Finished.");
                }
                catch (Throwable e) {
                    RunnableLogPanel.this.setLabel("Failed.");
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void setLabel(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RunnableLogPanel.this.label.setText(text);
            }
        });
    }

    private void addText(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    RunnableLogPanel.this.document.insertString(RunnableLogPanel.this.textOffset, text, SimpleAttributeSet.EMPTY);
                    RunnableLogPanel.this.textOffset += text.length();
                    RunnableLogPanel.this.scrollBarRangeModel.setValue(RunnableLogPanel.this.scrollBarRangeModel.getMaximum());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class GuiLogTarget
    implements LogTarget {
        long start = System.currentTimeMillis();

        private GuiLogTarget() {
        }

        public boolean isLevelEnabled(String topic, int level) {
            return true;
        }

        public void log(String topic, int level, Object message, Throwable throwable) {
            if (this.isLevelEnabled(topic, level)) {
                StringBuffer buffer = new StringBuffer(80);
                buffer.append("[");
                buffer.append(Constants.LEVEL_NAMES[level]);
                buffer.append("] ");
                buffer.append(System.currentTimeMillis() - this.start);
                buffer.append(" ");
                buffer.append(String.valueOf(message));
                if (throwable != null) {
                    buffer.append("\n");
                    buffer.append(Exceptions.printStackTrace(throwable));
                }
                buffer.append('\n');
                RunnableLogPanel.this.addText(buffer.toString());
            }
        }
    }
}

