/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.desktop.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.shiftone.jrat.util.log.Logger;

public class BrowserPanel
extends JPanel
implements HyperlinkListener,
ActionListener {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$desktop$util$BrowserPanel == null ? (class$org$shiftone$jrat$desktop$util$BrowserPanel = BrowserPanel.class$("org.shiftone.jrat.desktop.util.BrowserPanel")) : class$org$shiftone$jrat$desktop$util$BrowserPanel);
    private final URL homePage;
    private final JToolBar toolBar = new JToolBar();
    private final JEditorPane editorPane = new JEditorPane();
    private final JScrollPane scrollPane = new JScrollPane(this.editorPane);
    private final JLabel location = new JLabel();
    private final JButton home = new JButton("Home");
    private final JButton back = new JButton("Back");
    private final JButton forword = new JButton("Forward");
    private URL[] urls = new URL[1024];
    private int current;
    private int maxCurrent;
    static /* synthetic */ Class class$org$shiftone$jrat$desktop$util$BrowserPanel;

    public BrowserPanel(URL homePage) {
        this.homePage = homePage;
        HTMLEditorKit kit = new HTMLEditorKit();
        kit.setLinkCursor(Cursor.getPredefinedCursor(12));
        this.editorPane.setEditorKit(kit);
        this.editorPane.setEditable(false);
        this.editorPane.addHyperlinkListener(this);
        this.editorPane.setBorder(new EmptyBorder(20, 10, 10, 10));
        this.editorPane.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.location, "South");
        this.toolBar.add(this.home);
        this.toolBar.add(this.back);
        this.toolBar.add(this.forword);
        this.home.addActionListener(this);
        this.back.addActionListener(this);
        this.forword.addActionListener(this);
        this.setHyperLink(homePage, true);
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setHyperLink(e.getURL(), true);
        }
    }

    public void setHyperLink(URL url, boolean push) {
        try {
            if (url.equals(this.editorPane.getPage())) {
                return;
            }
            this.editorPane.setPage(url);
            if (push) {
                ++this.current;
                this.maxCurrent = this.current;
            } else {
                this.maxCurrent = Math.max(this.current, this.maxCurrent);
            }
            this.urls[this.current] = url;
            this.location.setText(this.current + " : " + url.toString());
            this.back.setEnabled(this.current > 1);
            this.forword.setEnabled(this.current < this.maxCurrent);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private void error(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        out.println("<b>Unable to open Documentation</b><p>");
        e.printStackTrace(out);
        out.flush();
        this.editorPane.setText(stringWriter.toString());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.home) {
            this.setHyperLink(this.homePage, true);
        } else if (e.getSource() == this.back) {
            if (this.current > 1) {
                --this.current;
                this.setHyperLink(this.urls[this.current], false);
            }
        } else if (e.getSource() == this.forword && this.current < this.maxCurrent) {
            ++this.current;
            this.setHyperLink(this.urls[this.current], false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

