/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.http;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.shiftone.jrat.http.Handler;
import org.shiftone.jrat.http.Request;
import org.shiftone.jrat.http.Response;
import org.shiftone.jrat.util.io.IOUtil;

public class FsBrowseHandler
implements Handler {
    private static final String ROOT = new File("").getAbsolutePath();
    private static Map mimeTypes = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(Request request, Response response) throws Exception {
        response.setContentType("text/html");
        String uri = request.getRequestUri();
        File file = new File(ROOT + uri);
        if (file.isDirectory()) {
            Writer writer = response.getWriter();
            writer.write("<ul>");
            File[] children = file.listFiles();
            int i = 0;
            while (true) {
                if (i >= children.length) {
                    writer.write("</ul>");
                    return;
                }
                File child = children[i];
                if (child.isDirectory()) {
                    writer.write("<li><a href='" + child.getName() + "/'>" + child.getName() + "/</a>");
                } else {
                    writer.write("<li><a href='" + child.getName() + "'>" + child.getName() + "</a> ");
                    writer.write(" (" + child.length() + " bytes)");
                }
                ++i;
            }
        }
        String ext = IOUtil.getExtention(file.getName()).toLowerCase();
        String contentType = (String)mimeTypes.get(ext);
        OutputStream outputStream = response.getOutputStream();
        InputStream inputStream = null;
        try {
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            response.setContentType(contentType);
            inputStream = IOUtil.openInputStream(file);
            IOUtil.copy(inputStream, outputStream);
        }
        catch (Throwable throwable) {
            IOUtil.close(inputStream);
            throw throwable;
        }
        IOUtil.close(inputStream);
    }

    static {
        mimeTypes.put("txt", "text/plain");
        mimeTypes.put("log", "text/plain");
        mimeTypes.put("htm", "text/html");
        mimeTypes.put("html", "text/html");
        mimeTypes.put("xml", "text/xml");
    }
}

