/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.shiftone.jrat.http.Status;
import org.shiftone.jrat.util.log.Logger;

public class Response {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$http$Response == null ? (class$org$shiftone$jrat$http$Response = Response.class$("org.shiftone.jrat.http.Response")) : class$org$shiftone$jrat$http$Response);
    private final OutputStream outputStream;
    private final Writer writer;
    private final ResponseWriter responseWriter = new ResponseWriter();
    private final ResponseOutputStream responseOutputStream = new ResponseOutputStream();
    private boolean committed = false;
    private Status status = Status.OK;
    private String contentType;
    static /* synthetic */ Class class$org$shiftone$jrat$http$Response;

    public Response(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.writer = new OutputStreamWriter(outputStream);
    }

    public Writer getWriter() {
        return this.responseWriter;
    }

    public OutputStream getOutputStream() {
        return this.responseOutputStream;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void flush() throws IOException {
        this.commit();
        this.writer.flush();
    }

    private void writeHeaders() throws IOException {
        String statusLine = "HTTP/1.1 " + this.status.getCode() + " " + this.status.getMessage();
        LOG.info(statusLine);
        this.writer.write(statusLine + "\n");
        this.writer.write("Content-Type: " + this.contentType + "\n");
        this.writer.write("Cache-Control: no-store, no-cache, must-revalidate\n");
        this.writer.write("Cache-Control: post-check=0, pre-check=0");
        this.writer.write("Pragma: no-cache\n");
        this.writer.write("Expires: Sat, 6 May 1995 12:00:00 GMT\n");
        this.writer.write("\n");
        this.writer.flush();
    }

    private void commit() throws IOException {
        if (!this.committed) {
            this.writeHeaders();
            this.committed = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ResponseWriter
    extends Writer {
        private ResponseWriter() {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            Response.this.commit();
            Response.this.writer.write(cbuf, off, len);
        }

        public void flush() throws IOException {
            Response.this.commit();
            Response.this.writer.flush();
        }

        public void close() throws IOException {
            Response.this.commit();
            Response.this.writer.close();
        }

        public void write(int c) throws IOException {
            Response.this.commit();
            super.write(c);
        }

        public void write(char[] cbuf) throws IOException {
            Response.this.commit();
            super.write(cbuf);
        }

        public void write(String str) throws IOException {
            Response.this.commit();
            super.write(str);
        }

        public void write(String str, int off, int len) throws IOException {
            Response.this.commit();
            super.write(str, off, len);
        }
    }

    private class ResponseOutputStream
    extends OutputStream {
        private ResponseOutputStream() {
        }

        public void write(int b) throws IOException {
            Response.this.commit();
            Response.this.outputStream.write(b);
        }

        public void write(byte[] b) throws IOException {
            Response.this.commit();
            Response.this.outputStream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            Response.this.commit();
            Response.this.outputStream.write(b, off, len);
        }

        public void flush() throws IOException {
            Response.this.commit();
            Response.this.outputStream.flush();
        }

        public void close() throws IOException {
            Response.this.commit();
            Response.this.outputStream.close();
        }
    }
}

