/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import org.shiftone.jrat.http.Dispatcher;
import org.shiftone.jrat.http.FsBrowseHandler;
import org.shiftone.jrat.http.Handler;
import org.shiftone.jrat.http.HttpException;
import org.shiftone.jrat.http.Request;
import org.shiftone.jrat.http.Response;
import org.shiftone.jrat.util.io.IOUtil;
import org.shiftone.jrat.util.log.Logger;

public class Server
extends Thread {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$http$Server == null ? (class$org$shiftone$jrat$http$Server = Server.class$("org.shiftone.jrat.http.Server")) : class$org$shiftone$jrat$http$Server);
    private final int port;
    private ServerSocket serverSocket;
    private Handler handler;
    static /* synthetic */ Class class$org$shiftone$jrat$http$Server;

    public Server(int port) {
        this.port = port;
        this.setDaemon(true);
        this.setName("HTTP Server");
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    private void initialize() {
        try {
            LOG.info("starting on port " + this.port + "...");
            this.serverSocket = new ServerSocket(this.port);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(Socket socket) throws Exception {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = socket.getInputStream();
            outputStream = socket.getOutputStream();
            Request request = new Request(inputStream);
            Response response = new Response(outputStream);
            try {
                this.handler.handle(request, response);
            }
            catch (HttpException e) {
                this.handleException(response, e);
            }
            response.flush();
        }
        finally {
            IOUtil.close(inputStream);
            IOUtil.close(outputStream);
        }
    }

    private void handleException(Response response, HttpException e) throws IOException {
        response.setStatus(e.getStatus());
        Writer out = response.getWriter();
        out.write("<h1>HTTP ");
        out.write(String.valueOf(e.getStatus().getCode()));
        out.write(" - ");
        out.write(e.getStatus().getMessage());
        out.write("</h1>");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        printWriter.flush();
        out.write("<pre>");
        out.write(stringWriter.toString());
        out.write("</pre>");
    }

    public void run() {
        this.initialize();
        while (true) {
            try {
                while (true) {
                    this.processRequest(this.serverSocket.accept());
                }
            }
            catch (Throwable e) {
                LOG.error("failed to processRequest request", e);
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        Dispatcher dispatcher = new Dispatcher("Root Dispatcher");
        Server server = new Server(8008);
        server.setHandler(dispatcher);
        server.setDaemon(false);
        server.start();
        Dispatcher dispatcher2 = new Dispatcher("dispatcher2");
        dispatcher.addRoute("1", dispatcher2);
        dispatcher.addRoute("2", dispatcher2);
        dispatcher.addRoute("3", dispatcher2);
        dispatcher.addRoute("4", dispatcher2);
        dispatcher.addRoute("5", dispatcher2);
        dispatcher.addRoute("fs", new FsBrowseHandler());
        Dispatcher dispatcher3 = new Dispatcher("dispatcher3");
        dispatcher2.addRoute("a", dispatcher3);
        dispatcher2.addRoute("b", dispatcher3);
        dispatcher2.addRoute("c", dispatcher3);
        dispatcher2.addRoute("d", dispatcher3);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

