/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.inject;

import java.io.File;
import org.shiftone.jrat.core.JRatException;
import org.shiftone.jrat.core.ServiceFactory;
import org.shiftone.jrat.core.criteria.MethodCriteria;
import org.shiftone.jrat.inject.InjectionException;
import org.shiftone.jrat.inject.InjectorOptions;
import org.shiftone.jrat.inject.bytecode.Transformer;
import org.shiftone.jrat.inject.process.CompositeFileProcessor;
import org.shiftone.jrat.inject.process.FileProcessor;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.io.IOUtil;
import org.shiftone.jrat.util.log.Logger;

public class Injector {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$inject$Injector == null ? (class$org$shiftone$jrat$inject$Injector = Injector.class$("org.shiftone.jrat.inject.Injector")) : class$org$shiftone$jrat$inject$Injector);
    public static final String WORK_FILE_END = "-JRatWorkFile";
    private FileProcessor fileProcessor = new CompositeFileProcessor();
    private InjectorOptions options = new InjectorOptions();
    private ServiceFactory serviceFactory = ServiceFactory.getInstance();
    private Transformer transformer = this.serviceFactory.getTransformer();
    static /* synthetic */ Class class$org$shiftone$jrat$inject$Injector;

    public void inject(File sourceFile, File targetFile) throws InjectionException {
        String sourceExt = IOUtil.getExtention(sourceFile);
        String targetExt = IOUtil.getExtention(targetFile);
        File targetDir = targetFile.getParentFile();
        Assert.assertSame("file extentions", sourceExt, targetExt);
        if (targetDir != null && !targetDir.exists() && !targetDir.mkdirs()) {
            throw new InjectionException("error creating parent directory of target file : " + targetDir);
        }
        this.fileProcessor.process(this.transformer, this.options, sourceFile, targetFile);
    }

    public void inject(String source, String target) throws InjectionException {
        this.inject(new File(source), new File(target));
    }

    public void inject(File file) throws InjectionException {
        if (file.getName().endsWith(WORK_FILE_END)) {
            try {
                IOUtil.delete(file);
            }
            catch (JRatException e) {
                LOG.warn("unable to delete : " + file);
            }
        } else {
            this.inject(file, file);
        }
    }

    public void inject(String fileName) throws InjectionException {
        this.inject(new File(fileName));
    }

    public MethodCriteria getMethodCriteria() {
        return this.options.getCriteria();
    }

    public void setMethodCriteria(MethodCriteria criteria) {
        this.options.setCriteria(criteria);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

