/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.inject.ant;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public abstract class AbstractFileTask
extends Task {
    protected Vector filesets = new Vector();
    protected File file = null;

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setFile(File file) {
        this.file = file;
    }

    protected abstract void validateFile(File var1) throws BuildException;

    protected abstract void processFile(File var1) throws BuildException;

    private void processFiles(Set fileNames) throws BuildException {
        Iterator iterator = fileNames.iterator();
        while (iterator.hasNext()) {
            this.processFile((File)iterator.next());
        }
    }

    public void execute() throws BuildException {
        TreeSet<File> files = new TreeSet<File>();
        String fileName = null;
        File fileToAdd = null;
        try {
            if (this.file != null) {
                this.validateFile(this.file);
                files.add(this.file);
            }
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fs = (FileSet)this.filesets.elementAt(i);
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File fromDir = fs.getDir(this.getProject());
                String[] srcFiles = ds.getIncludedFiles();
                for (int x = 0; x < srcFiles.length; ++x) {
                    fileName = fromDir + File.separator + srcFiles[x];
                    fileToAdd = new File(fileName);
                    this.validateFile(fileToAdd);
                    files.add(fileToAdd);
                }
            }
            this.processFiles(files);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new BuildException("file task failed", e);
        }
    }
}

