/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.inject.ant;

import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.shiftone.jrat.core.criteria.IncludeExcludeMethodCriteria;
import org.shiftone.jrat.core.criteria.MatcherMethodCriteria;
import org.shiftone.jrat.inject.Injector;
import org.shiftone.jrat.inject.process.ArchiveFileProcessor;
import org.shiftone.jrat.util.io.IOUtil;
import org.shiftone.jrat.util.log.Logger;

public class InjectCopyTask
extends Copy {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$inject$ant$InjectCopyTask == null ? (class$org$shiftone$jrat$inject$ant$InjectCopyTask = InjectCopyTask.class$("org.shiftone.jrat.inject.ant.InjectCopyTask")) : class$org$shiftone$jrat$inject$ant$InjectCopyTask);
    private Injector injector = new Injector();
    private IncludeExcludeMethodCriteria methodCriteria = new IncludeExcludeMethodCriteria();
    static /* synthetic */ Class class$org$shiftone$jrat$inject$ant$InjectCopyTask;

    public InjectCopyTask() {
        this.injector.setMethodCriteria(this.methodCriteria);
    }

    public MatcherMethodCriteria createInclude() {
        MatcherMethodCriteria newCriteria = new MatcherMethodCriteria();
        this.methodCriteria.addPositive(newCriteria);
        return newCriteria;
    }

    public MatcherMethodCriteria createExclude() {
        MatcherMethodCriteria newCriteria = new MatcherMethodCriteria();
        this.methodCriteria.addNegative(newCriteria);
        return newCriteria;
    }

    private void copyOrInjectFile(String fromFile, String toFile, FilterSetCollection executionFilters) throws Exception {
        String extention = IOUtil.getExtention(fromFile);
        if (extention != null && ("class".equalsIgnoreCase(extention) || ArchiveFileProcessor.isArchiveExtention(extention))) {
            this.injector.inject(fromFile, toFile);
        } else if (fromFile.equals(toFile)) {
            this.log("Skipping self-copy of " + fromFile, this.verbosity);
        } else {
            this.getFileUtils().copyFile(fromFile, toFile, executionFilters, this.getFilterChains(), this.forceOverwrite, this.preserveLastModified, this.getEncoding(), this.getProject());
        }
    }

    private String getString(Object to) {
        if (to instanceof String) {
            return (String)to;
        }
        if (to instanceof String[]) {
            return ((String[])to)[0];
        }
        throw new RuntimeException("Error - please report a bug : " + to.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    protected void doFileOperations() {
        TreeMap treeMap = new TreeMap(this.fileCopyMap);
        if (treeMap.size() > 0) {
            this.log("Copying " + treeMap.size() + " file" + (treeMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath(), this.verbosity);
            Iterator orderedCopyMap = treeMap.keySet().iterator();
            while (orderedCopyMap.hasNext()) {
                void sourceFiles;
                String fromFile = (String)orderedCopyMap.next();
                Object to = sourceFiles.get(fromFile);
                String toFile = this.getString(to);
                try {
                    FilterSetCollection executionFilters = new FilterSetCollection();
                    if (this.filtering) {
                        executionFilters.addFilterSet(this.getProject().getGlobalFilterSet());
                    }
                    Enumeration filterEnum = this.getFilterSets().elements();
                    while (filterEnum.hasMoreElements()) {
                        executionFilters.addFilterSet((FilterSet)filterEnum.nextElement());
                    }
                    this.copyOrInjectFile(fromFile, toFile, executionFilters);
                }
                catch (Exception e) {
                    LOG.error("InjectCopyTask error", e);
                    throw new BuildException("Error instramenting " + fromFile, (Throwable)e, this.getLocation());
                }
            }
        }
        if (this.includeEmpty) {
            this.copyEmptyDirectories();
        }
    }

    private void copyEmptyDirectories() {
        Enumeration e = this.dirCopyMap.elements();
        int count = 0;
        while (e.hasMoreElements()) {
            File d = new File(this.getString(e.nextElement()));
            if (d.exists()) continue;
            if (!d.mkdirs()) {
                this.log("Unable to column directory " + d.getAbsolutePath(), 0);
                continue;
            }
            ++count;
        }
        if (count > 0) {
            this.log("Copied " + count + " empty director" + (count == 1 ? "y" : "ies") + " to " + this.destDir.getAbsolutePath(), this.verbosity);
        }
    }

    public void execute() throws BuildException {
        try {
            super.execute();
        }
        catch (BuildException e) {
            LOG.error("copy failed", e);
            throw e;
        }
        catch (Throwable e) {
            LOG.error("copy failed", e);
            throw new BuildException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

