/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.inject.bytecode;

import java.io.InputStream;
import org.shiftone.jrat.core.JRatException;
import org.shiftone.jrat.core.shutdown.ShutdownListener;
import org.shiftone.jrat.inject.bytecode.InjectorStrategy;
import org.shiftone.jrat.inject.bytecode.TransformerMBean;
import org.shiftone.jrat.inject.bytecode.TransformerOptions;
import org.shiftone.jrat.inject.bytecode.asm.AsmInjectorStrategy;
import org.shiftone.jrat.util.AtomicLong;
import org.shiftone.jrat.util.io.IOUtil;
import org.shiftone.jrat.util.log.Logger;

public class Transformer
implements ShutdownListener,
TransformerMBean {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$inject$bytecode$Transformer == null ? (class$org$shiftone$jrat$inject$bytecode$Transformer = Transformer.class$("org.shiftone.jrat.inject.bytecode.Transformer")) : class$org$shiftone$jrat$inject$bytecode$Transformer);
    private static final String UNKNOWN_SOURCE = "[unknown source]";
    private InjectorStrategy injectorStrategy;
    private AtomicLong transformedClassCount = new AtomicLong();
    private AtomicLong totalInputBytes = new AtomicLong();
    private AtomicLong totalOutputBytes = new AtomicLong();
    private AtomicLong totalTransformTime = new AtomicLong();
    static /* synthetic */ Class class$org$shiftone$jrat$inject$bytecode$Transformer;

    public Transformer(InjectorStrategy injectorStrategy) {
        this.injectorStrategy = injectorStrategy;
    }

    public Transformer() {
        this.injectorStrategy = new AsmInjectorStrategy();
    }

    public byte[] inject(byte[] inputClassData, TransformerOptions options) {
        return this.inject(inputClassData, UNKNOWN_SOURCE, options);
    }

    public byte[] inject(InputStream inputClassData, TransformerOptions options) {
        return this.inject(inputClassData, UNKNOWN_SOURCE, options);
    }

    public byte[] inject(byte[] input, String sourceName, TransformerOptions options) {
        try {
            long start = System.currentTimeMillis();
            byte[] output = this.injectorStrategy.inject(input, options);
            this.totalTransformTime.addAndGet(System.currentTimeMillis() - start);
            this.totalInputBytes.addAndGet(input.length);
            this.totalOutputBytes.addAndGet(output.length);
            this.transformedClassCount.incrementAndGet();
            return output;
        }
        catch (Exception exception) {
            throw new JRatException("error injecting : " + sourceName, exception);
        }
    }

    public long getTransformedClassCount() {
        return this.transformedClassCount.get();
    }

    public double getAverageTransformTimeMs() {
        return this.transformedClassCount.get() == 0L ? 0.0 : (double)this.totalTransformTime.get() / (double)this.transformedClassCount.get();
    }

    public double getAverageBloatPercent() {
        return (double)this.totalOutputBytes.get() * 100.0 / (double)this.totalInputBytes.get() - 100.0;
    }

    public String getInjectorStrategyText() {
        return this.injectorStrategy.toString();
    }

    public byte[] inject(InputStream inputClassData, String sourceName, TransformerOptions options) {
        try {
            byte[] inputClassDataBytes = IOUtil.readAndClose(inputClassData);
            return this.inject(inputClassDataBytes, sourceName, options);
        }
        catch (Exception e) {
            throw new JRatException("error injecting stream : " + sourceName, e);
        }
    }

    public void shutdown() {
        LOG.info("transformed " + this.transformedClassCount + " classe(s)");
    }

    public String toString() {
        return "Transformer[" + this.injectorStrategy + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

