/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.inject.bytecode.asm;

import org.shiftone.jrat.depends.asm.ClassReader;
import org.shiftone.jrat.depends.asm.ClassWriter;
import org.shiftone.jrat.depends.asm.commons.SerialVersionUIDAdder;
import org.shiftone.jrat.inject.bytecode.InjectorStrategy;
import org.shiftone.jrat.inject.bytecode.TransformerOptions;
import org.shiftone.jrat.inject.bytecode.asm.ClassInitClassVisitor;
import org.shiftone.jrat.inject.bytecode.asm.IfInterfaceClassVisitor;
import org.shiftone.jrat.inject.bytecode.asm.InjectClassVisitor;
import org.shiftone.jrat.inject.bytecode.asm.MethodCriteriaClassVisitor;

public class AsmInjectorStrategy
implements InjectorStrategy {
    public byte[] inject(byte[] rawClassData, TransformerOptions options) throws Exception {
        ClassWriter classWriter;
        ClassReader reader = new ClassReader(rawClassData);
        ClassWriter target = classWriter = new ClassWriter(true);
        ClassInitClassVisitor classInitClassVisitor = new ClassInitClassVisitor(target);
        SerialVersionUIDAdder serialVersionUIDAdder = new SerialVersionUIDAdder(classInitClassVisitor);
        InjectClassVisitor injectClassVisitor = new InjectClassVisitor(serialVersionUIDAdder);
        MethodCriteriaClassVisitor criteriaClassVisitor = new MethodCriteriaClassVisitor(injectClassVisitor, serialVersionUIDAdder);
        IfInterfaceClassVisitor visitor = new IfInterfaceClassVisitor(target, criteriaClassVisitor);
        criteriaClassVisitor.setCriteria(options.getCriteria());
        reader.accept(visitor, false);
        return classWriter.toByteArray();
    }

    public String toString() {
        return "ASM";
    }
}

