/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.inject.bytecode.asm;

import java.util.Date;
import org.shiftone.jrat.core.JRatException;
import org.shiftone.jrat.depends.asm.ClassAdapter;
import org.shiftone.jrat.depends.asm.ClassVisitor;
import org.shiftone.jrat.depends.asm.FieldVisitor;
import org.shiftone.jrat.depends.asm.MethodVisitor;
import org.shiftone.jrat.depends.asm.Opcodes;
import org.shiftone.jrat.depends.asm.Type;
import org.shiftone.jrat.depends.asm.commons.GeneratorAdapter;
import org.shiftone.jrat.depends.asm.commons.Method;
import org.shiftone.jrat.inject.bytecode.Modifier;
import org.shiftone.jrat.inject.bytecode.asm.Constants;
import org.shiftone.jrat.inject.bytecode.asm.ProxyMethodVisitor;
import org.shiftone.jrat.util.VersionUtil;
import org.shiftone.jrat.util.log.Logger;

public class InjectClassVisitor
extends ClassAdapter
implements Constants,
Opcodes {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$inject$bytecode$asm$InjectClassVisitor == null ? (class$org$shiftone$jrat$inject$bytecode$asm$InjectClassVisitor = InjectClassVisitor.class$("org.shiftone.jrat.inject.bytecode.asm.InjectClassVisitor")) : class$org$shiftone$jrat$inject$bytecode$asm$InjectClassVisitor);
    private int handlerCount;
    private Type classType;
    private GeneratorAdapter initializer;
    static /* synthetic */ Class class$org$shiftone$jrat$inject$bytecode$asm$InjectClassVisitor;

    public InjectClassVisitor(ClassVisitor visitor) {
        super(visitor);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.handlerCount = 0;
        this.classType = Type.getType("L" + name.replace('.', '/') + ";");
        super.visit(version, access, name, signature, superName, interfaces);
        this.initializer = this.addInitializer();
    }

    private GeneratorAdapter addInitializer() {
        int access = 10;
        String descriptor = "()V";
        MethodVisitor initMethodVisitor = super.visitMethod(access, "$clinit_$jrat", descriptor, null, null);
        GeneratorAdapter initializer = new GeneratorAdapter(initMethodVisitor, access, "$clinit_$jrat", descriptor);
        initMethodVisitor.visitCode();
        return initializer;
    }

    public void visitEnd() {
        this.initializer.returnValue();
        this.initializer.endMethod();
        this.addCommentField();
        super.visitEnd();
    }

    private void addCommentField() {
        FieldVisitor commentField = super.visitField(26, "$hiftOne_JRat_was_here", "Ljava/lang/String;", null, "Class enhanced on " + new Date() + " w/ version JRat v" + VersionUtil.getBuiltOn() + " built on " + VersionUtil.getBuiltOn());
        commentField.visitEnd();
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (name.equals("$hiftOne_JRat_was_here")) {
            throw new JRatException("this class was previously injected by JRat");
        }
        return super.visitField(access, name, desc, signature, value);
    }

    private void addMethodHandlerField(String fieldName, String methodName, String descriptor) {
        FieldVisitor handler = super.visitField(26, fieldName, Constants.MethodHandler.TYPE.getDescriptor(), null, null);
        handler.visitEnd();
        this.initializer.push(this.classType.getClassName());
        this.initializer.push(methodName);
        this.initializer.push(descriptor);
        this.initializer.invokeStatic(Constants.HandlerFactory.TYPE, Constants.HandlerFactory.getMethodHandler);
        this.initializer.putStatic(this.classType, fieldName, Constants.MethodHandler.TYPE);
    }

    public void pushThis(GeneratorAdapter adapter, boolean isStatic) {
        if (isStatic) {
            adapter.push("test");
        } else {
            adapter.loadThis();
        }
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (name.equals("<clinit>") || name.equals("<init>") || Modifier.isAbstract(access) || Modifier.isNative(access)) {
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
        int index = this.handlerCount++;
        String handlerFieldName = "jrat$" + index;
        String targetMethodName = name + "_$jrat";
        this.addMethodHandlerField(handlerFieldName, name, descriptor);
        Method method = new Method(name, descriptor);
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        ProxyMethodVisitor visitor = new ProxyMethodVisitor(access, method, mv, this.classType, targetMethodName, handlerFieldName);
        visitor.visitCode();
        visitor.visitEnd();
        return super.visitMethod(Modifier.makePrivate(access), targetMethodName, descriptor, signature, exceptions);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

