/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.inject.process;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.shiftone.jrat.core.JRatException;
import org.shiftone.jrat.inject.InjectorOptions;
import org.shiftone.jrat.inject.bytecode.Transformer;
import org.shiftone.jrat.inject.process.FileProcessor;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.io.IOUtil;
import org.shiftone.jrat.util.log.Logger;

public abstract class AbstractFileProcessor
implements FileProcessor {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$inject$process$AbstractFileProcessor == null ? (class$org$shiftone$jrat$inject$process$AbstractFileProcessor = AbstractFileProcessor.class$("org.shiftone.jrat.inject.process.AbstractFileProcessor")) : class$org$shiftone$jrat$inject$process$AbstractFileProcessor);
    private static final long DEFAULT_BUFFER_SIZE = 6144L;
    private boolean forceOverwrite = true;
    private boolean overwriteNewer = false;
    private boolean preserveLastModified = false;
    static /* synthetic */ Class class$org$shiftone$jrat$inject$process$AbstractFileProcessor;

    public void process(Transformer transformer, InjectorOptions options, File source, File target) {
        LOG.debug("process " + source.getAbsolutePath() + " " + target.getAbsolutePath());
        Assert.assertNotNull("transformer", transformer);
        if (!source.exists()) {
            throw new JRatException("source file does not exist : " + source);
        }
        LOG.debug("source exists");
        if (source.isDirectory()) {
            throw new JRatException("source file is a directory : " + source);
        }
        LOG.debug("source is real file (not dir)");
        if (!source.canRead()) {
            throw new JRatException("source file can not be read (check permissions): " + source);
        }
        LOG.debug("source can be read");
        long lastModified = source.lastModified();
        if (target.exists()) {
            LOG.debug("target exists " + target.getAbsolutePath());
            if (!this.forceOverwrite) {
                throw new JRatException("target exists and forceOverwrite is disabled : " + source);
            }
            if (target.isDirectory()) {
                throw new JRatException("target is directory : " + target);
            }
            if (!target.canWrite()) {
                throw new JRatException("unable to write to target (check permissions) : " + target);
            }
            if (target.lastModified() > source.lastModified() && !this.overwriteNewer) {
                throw new JRatException("target is newer than source and overwriteNewer is disabled : " + source);
            }
            this.processUsingSwapFile(transformer, options, source, target);
        } else {
            LOG.debug("target does not exist " + target.getAbsolutePath());
            this.processFile(transformer, options, source, target);
        }
        if (this.preserveLastModified) {
            target.setLastModified(lastModified);
        }
    }

    protected void processUsingSwapFile(Transformer transformer, InjectorOptions options, File source, File target) {
        LOG.debug("processUsingSwapFile " + source.getAbsolutePath() + " " + target.getAbsolutePath());
        File workFile = new File(target.getAbsolutePath() + "-JRatWorkFile");
        if (workFile.exists()) {
            LOG.info("workfile found, deleting");
            IOUtil.delete(workFile);
        }
        try {
            this.processFile(transformer, options, source, workFile);
            if (!workFile.exists()) {
                throw new JRatException("processFile seems to have worked, but target file doesn't exist : " + source);
            }
            IOUtil.rename(workFile, target, true);
        }
        catch (Throwable e) {
            String msg = "Failed to instrument " + source + " : " + e;
            if (workFile.exists() && !workFile.delete()) {
                msg = msg + " and couldn't delete the corrupt file " + workFile.getAbsolutePath();
            }
            throw new JRatException(msg, e);
        }
        finally {
            IOUtil.deleteIfExists(workFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFile(Transformer transformer, InjectorOptions options, File source, File target) {
        int bufferSize = (int)Math.min(6144L, source.length());
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = IOUtil.openInputStream(source, bufferSize);
            outputStream = IOUtil.openOutputStream(target, bufferSize);
            LOG.debug("calling processStream");
            this.processStream(transformer, options, inputStream, outputStream, source.getName());
        }
        catch (Throwable throwable) {
            IOUtil.close(inputStream);
            IOUtil.close(outputStream);
            throw throwable;
        }
        IOUtil.close(inputStream);
        IOUtil.close(outputStream);
    }

    protected void processStream(Transformer transformer, InjectorOptions options, InputStream inputStream, OutputStream outputStream, String fileName) {
        throw new UnsupportedOperationException("processStream should be implemented by derived class");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

