/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.inject.process;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.shiftone.jrat.core.JRatException;
import org.shiftone.jrat.inject.InjectorOptions;
import org.shiftone.jrat.inject.bytecode.Transformer;
import org.shiftone.jrat.inject.bytecode.TransformerOptions;
import org.shiftone.jrat.inject.process.AbstractFileProcessor;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.VersionUtil;
import org.shiftone.jrat.util.io.IOUtil;
import org.shiftone.jrat.util.io.OpenInputStream;
import org.shiftone.jrat.util.log.Logger;
import org.shiftone.jrat.util.regex.CompositeMatcher;
import org.shiftone.jrat.util.regex.Matcher;

public class ArchiveFileProcessor
extends AbstractFileProcessor {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$inject$process$ArchiveFileProcessor == null ? (class$org$shiftone$jrat$inject$process$ArchiveFileProcessor = ArchiveFileProcessor.class$("org.shiftone.jrat.inject.process.ArchiveFileProcessor")) : class$org$shiftone$jrat$inject$process$ArchiveFileProcessor);
    private static final Matcher EXTENTION_MATCHER = CompositeMatcher.buildCompositeGlobMatcher("zip,jar,ear,war,sar,har");
    private static final int BUFFER_SIZE = 65536;
    static /* synthetic */ Class class$org$shiftone$jrat$inject$process$ArchiveFileProcessor;

    protected void processFile(Transformer transformer, InjectorOptions options, File source, File target) {
        LOG.debug("processFile " + source.getAbsolutePath() + " => " + target.getAbsolutePath());
        ZipInputStream sourceStream = new ZipInputStream(IOUtil.openInputStream(source, 65536));
        ZipOutputStream targetStream = new ZipOutputStream(IOUtil.openOutputStream(target, 65536));
        targetStream.setLevel(1);
        try {
            this.processStreams(transformer, options, sourceStream, targetStream);
        }
        catch (Exception e) {
            throw new JRatException("error injecting " + source.getAbsoluteFile() + " => " + target.getAbsolutePath(), e);
        }
        finally {
            IOUtil.close(sourceStream);
            IOUtil.close(targetStream);
        }
    }

    protected boolean processStreams(Transformer transformer, InjectorOptions options, ZipInputStream sourceStream, ZipOutputStream targetStream) throws Exception {
        Assert.assertNotNull("transformer", transformer);
        ZipEntry inEntry = null;
        ZipEntry outEntry = null;
        this.addReadmeCommentFile(targetStream);
        while ((inEntry = sourceStream.getNextEntry()) != null) {
            outEntry = new ZipEntry(inEntry.getName());
            OpenInputStream entryInputStream = new OpenInputStream(sourceStream);
            targetStream.putNextEntry(outEntry);
            String ext = this.getNormalizedExtention(inEntry);
            if (ArchiveFileProcessor.isArchiveExtention(ext)) {
                LOG.info("Entering nested archive : " + outEntry.getName());
                ZipInputStream nestedSourceStream = new ZipInputStream(entryInputStream);
                ZipOutputStream nestedTargetStream = new ZipOutputStream(targetStream);
                this.processStreams(transformer, options, nestedSourceStream, nestedTargetStream);
                nestedTargetStream.finish();
            } else if (this.isClassExtention(ext)) {
                LOG.debug("injecting " + inEntry.getName());
                byte[] transformedClass = transformer.inject(entryInputStream, inEntry.getName(), (TransformerOptions)options);
                targetStream.write(transformedClass);
            } else {
                LOG.debug("copying " + inEntry.getName());
                IOUtil.copy(entryInputStream, targetStream);
            }
            targetStream.closeEntry();
        }
        return true;
    }

    private void addReadmeCommentFile(ZipOutputStream zipOutputStream) {
        ZipEntry entry = new ZipEntry("_READ_ME.JRAT");
        try {
            zipOutputStream.putNextEntry(entry);
            PrintStream printStream = new PrintStream(zipOutputStream);
            printStream.println("# This Archive file was injected by");
            printStream.println("# Shiftone JRat the Java Runtime Analysis Toolkit");
            printStream.println("# For more information, visit http://jrat.sourceforge.net");
            printStream.println("#\tVersion  : " + VersionUtil.getVersion());
            printStream.println("#\tBuilt On : " + VersionUtil.getBuiltOn());
            printStream.println("#\tBuilt By : " + VersionUtil.getBuiltBy());
            printStream.println();
            printStream.println();
            printStream.println();
            printStream.println("# the following system properties were present during injection");
            printStream.flush();
            System.getProperties().store(zipOutputStream, null);
            zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            throw new JRatException("unable to add comment file to archive", e);
        }
    }

    private String getNormalizedExtention(ZipEntry entry) {
        return IOUtil.getExtention(entry.getName());
    }

    public static boolean isArchiveExtention(String ext) {
        return EXTENTION_MATCHER.isMatch(ext);
    }

    public boolean isClassExtention(String ext) {
        return ext != null && ext.equals("class");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

