/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.jvmti;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import org.shiftone.jrat.core.Environment;
import org.shiftone.jrat.core.Mode;
import org.shiftone.jrat.core.config.Configuration;
import org.shiftone.jrat.inject.InjectorOptions;
import org.shiftone.jrat.jvmti.FilterClassFileTransformer;
import org.shiftone.jrat.jvmti.InjectClassFileTransformer;
import org.shiftone.jrat.jvmti.SystemPropertyTweakingTransformer;
import org.shiftone.jrat.jvmti.TryCatchClassFileTransformer;
import org.shiftone.jrat.util.VersionUtil;
import org.shiftone.jrat.util.log.Logger;

public class Agent {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$jvmti$Agent == null ? (class$org$shiftone$jrat$jvmti$Agent = Agent.class$("org.shiftone.jrat.jvmti.Agent")) : class$org$shiftone$jrat$jvmti$Agent);
    private static boolean installed = false;
    private static Configuration configuration;
    static /* synthetic */ Class class$org$shiftone$jrat$jvmti$Agent;

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        Mode.set(Mode.RUNTIME);
        if (installed) {
            LOG.warn("one JRat Agent was already installed.");
            LOG.warn("your probably have the -javaagent arg on the command line twice");
            return;
        }
        LOG.info("Installing JRat " + VersionUtil.getVersion() + " ClassFileTransformer...");
        if (configuration == null) {
            configuration = Environment.getConfiguration();
        }
        InjectorOptions injectorOptions = new InjectorOptions();
        injectorOptions.setCriteria(configuration);
        try {
            ClassFileTransformer transformer = new InjectClassFileTransformer(injectorOptions);
            transformer = new FilterClassFileTransformer(configuration, transformer);
            if (configuration.getSettings().isSystemPropertyTweakingEnabled()) {
                transformer = new SystemPropertyTweakingTransformer(transformer);
            }
            transformer = new TryCatchClassFileTransformer(transformer);
            instrumentation.addTransformer(transformer);
            LOG.info("Installed " + transformer + ".");
            installed = true;
        }
        catch (Throwable e) {
            LOG.info("NOT Installed!", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

