/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.jvmti;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.shiftone.jrat.core.criteria.MethodCriteria;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.log.Logger;

public class FilterClassFileTransformer
implements ClassFileTransformer {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$jvmti$FilterClassFileTransformer == null ? (class$org$shiftone$jrat$jvmti$FilterClassFileTransformer = FilterClassFileTransformer.class$("org.shiftone.jrat.jvmti.FilterClassFileTransformer")) : class$org$shiftone$jrat$jvmti$FilterClassFileTransformer);
    private final MethodCriteria methodCriteria;
    private final ClassFileTransformer transformer;
    static /* synthetic */ Class class$org$shiftone$jrat$jvmti$FilterClassFileTransformer;

    public FilterClassFileTransformer(MethodCriteria methodCriteria, ClassFileTransformer transformer) {
        Assert.assertNotNull("methodCriteria", methodCriteria);
        Assert.assertNotNull("transformer", transformer);
        this.methodCriteria = methodCriteria;
        this.transformer = transformer;
    }

    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        String fixedClassName = className.replace('/', '.');
        int modifiers = 0;
        if (classBeingRedefined != null) {
            modifiers = classBeingRedefined.getModifiers();
        }
        if (this.methodCriteria.isMatch(fixedClassName, modifiers)) {
            return this.transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
        }
        return classfileBuffer;
    }

    public String toString() {
        return "FilterClassFileTransformer[" + this.methodCriteria + " : " + this.transformer + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

