/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.jvmti;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.shiftone.jrat.util.log.Logger;

public class SystemPropertyTweakingTransformer
implements ClassFileTransformer {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$jvmti$SystemPropertyTweakingTransformer == null ? (class$org$shiftone$jrat$jvmti$SystemPropertyTweakingTransformer = SystemPropertyTweakingTransformer.class$("org.shiftone.jrat.jvmti.SystemPropertyTweakingTransformer")) : class$org$shiftone$jrat$jvmti$SystemPropertyTweakingTransformer);
    private final ClassFileTransformer transformer;
    private boolean loggedDisableMessage = false;
    static /* synthetic */ Class class$org$shiftone$jrat$jvmti$SystemPropertyTweakingTransformer;

    public SystemPropertyTweakingTransformer(ClassFileTransformer transformer) {
        this.transformer = transformer;
    }

    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (className.startsWith("org/jboss/")) {
            this.setSystemProperty("jboss.shutdown.forceHalt", "false", "You appear to be running JBoss. Tweaking system property to allow proper shutdown.");
        }
        return this.transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
    }

    private void setSystemProperty(String key, String value, String reason) {
        if (value.equals(System.getProperty(key))) {
            return;
        }
        LOG.info(reason);
        LOG.info("Setting system property : " + key + " = " + value);
        if (!this.loggedDisableMessage) {
            LOG.info("To prevent JRat from mucking with your system properties, configure 'systemPropertyTweakingEnabled' = false");
            this.loggedDisableMessage = true;
        }
        System.setProperty(key, value);
    }

    public String toString() {
        return "SystemPropertyTweakingTransformer[" + this.transformer + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

