/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.shiftone.jrat.core.Accumulator;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.util.log.Logger;

public class TreeNode
implements Externalizable {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$provider$tree$TreeNode == null ? (class$org$shiftone$jrat$provider$tree$TreeNode = TreeNode.class$("org.shiftone.jrat.provider.tree.TreeNode")) : class$org$shiftone$jrat$provider$tree$TreeNode);
    private static final long serialVersionUID = 1L;
    protected MethodKey methodKey;
    protected TreeNode parent;
    private Accumulator accumulator;
    protected HashMap children = new HashMap(5);
    static /* synthetic */ Class class$org$shiftone$jrat$provider$tree$TreeNode;

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.accumulator);
        out.writeObject(this.methodKey);
        List list = this.getChildren();
        int childCount = list.size();
        out.writeInt(childCount);
        for (int i = 0; i < childCount; ++i) {
            TreeNode child = (TreeNode)list.get(i);
            child.writeExternal(out);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.accumulator = (Accumulator)in.readObject();
        this.methodKey = (MethodKey)in.readObject();
        int childCount = in.readInt();
        for (int i = 0; i < childCount; ++i) {
            TreeNode child = new TreeNode();
            child.readExternal(in);
            this.children.put(child.getMethodKey(), child);
            child.parent = this;
        }
    }

    public TreeNode() {
        this.methodKey = null;
        this.parent = null;
        this.accumulator = new Accumulator();
    }

    public TreeNode(MethodKey methodKey, TreeNode treeNode) {
        this.methodKey = methodKey;
        this.parent = treeNode;
        this.accumulator = new Accumulator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildren() {
        ArrayList list = new ArrayList();
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            list.addAll(this.children.values());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeNode getChild(MethodKey methodKey) {
        TreeNode treeNode = null;
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            treeNode = (TreeNode)this.children.get(methodKey);
            if (treeNode == null) {
                treeNode = new TreeNode(methodKey, this);
                this.children.put(methodKey, treeNode);
            }
        }
        return treeNode;
    }

    public final TreeNode getParentNode() {
        return this.parent;
    }

    public final boolean isRootNode() {
        return this.methodKey == null;
    }

    public Accumulator getAccumulator() {
        return this.accumulator;
    }

    public MethodKey getMethodKey() {
        return this.methodKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        ArrayList list = new ArrayList();
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            list.addAll(this.children.values());
        }
        for (int i = 0; i < list.size(); ++i) {
            TreeNode treeNode = (TreeNode)list.get(i);
            treeNode.reset();
        }
        this.accumulator.reset();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

