/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import org.shiftone.jrat.core.Accumulator;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.provider.tree.TreeNode;
import org.shiftone.jrat.util.collection.ArrayEnumeration;
import org.shiftone.jrat.util.log.Logger;

public class TraceTreeNode
implements javax.swing.tree.TreeNode {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$provider$tree$ui$TraceTreeNode == null ? (class$org$shiftone$jrat$provider$tree$ui$TraceTreeNode = TraceTreeNode.class$("org.shiftone.jrat.provider.tree.ui.TraceTreeNode")) : class$org$shiftone$jrat$provider$tree$ui$TraceTreeNode);
    private final MethodKey methodKey;
    private final Accumulator accumulator;
    private final Double averageMethodDuration;
    private final long totalMethodDuration;
    private final int depth;
    private final TraceTreeNode[] childArray;
    private final TraceTreeNode parent;
    private double pctOfAvgRootDuration;
    private double pctOfAvgParentDuration;
    private int totalChildren;
    private int maxDepth;
    static /* synthetic */ Class class$org$shiftone$jrat$provider$tree$ui$TraceTreeNode;

    public TraceTreeNode(TreeNode node) {
        this(node, 0, null, null);
    }

    /*
     * WARNING - void declaration
     */
    private TraceTreeNode(TreeNode node, int depth, TraceTreeNode parent, TraceTreeNode root) {
        long rootTotalDuration;
        long parentTotalDuration;
        this.methodKey = node.getMethodKey();
        this.accumulator = node.getAccumulator();
        this.depth = depth;
        this.parent = parent;
        if (parent != null && this.getTotalExits() > 0L && (parentTotalDuration = parent.getTotalDuration()) > 0L) {
            this.pctOfAvgParentDuration = 100.0 * (double)this.getTotalDuration() / (double)parentTotalDuration;
        }
        if (root != null && this.getTotalExits() > 0L && (rootTotalDuration = root.getTotalDuration()) > 0L) {
            this.pctOfAvgRootDuration = 100.0 * (double)this.getTotalDuration() / (double)rootTotalDuration;
        }
        List list = node.getChildren();
        this.childArray = new TraceTreeNode[list.size()];
        int n = 0;
        while (n < this.childArray.length) {
            void childStackTreeNode;
            TreeNode treeNode = (TreeNode)list.get(n);
            TraceTreeNode traceTreeNode = new TraceTreeNode(treeNode, depth + 1, this, root);
            this.totalChildren += 1 + traceTreeNode.totalChildren;
            this.maxDepth = Math.max(this.maxDepth, 1 + traceTreeNode.maxDepth);
            this.childArray[childStackTreeNode] = traceTreeNode;
            ++childStackTreeNode;
        }
        Arrays.sort(this.childArray, TotalChildrenComparator.INSTANCE);
        long l = this.getTotalDuration();
        for (int i = 0; i < this.childArray.length; ++i) {
            l -= this.childArray[i].getTotalDuration();
        }
        this.totalMethodDuration = l;
        this.averageMethodDuration = this.getTotalExits() == 0L ? null : new Double(this.totalMethodDuration / this.getTotalExits());
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public int getDepth() {
        return this.depth;
    }

    public double getPctOfAvgParentDuration() {
        return this.pctOfAvgParentDuration;
    }

    public double getPctOfAvgRootDuration() {
        return this.pctOfAvgRootDuration;
    }

    public Double getAverageMethodDuration() {
        return this.averageMethodDuration;
    }

    public long getTotalMethodDuration() {
        return this.totalMethodDuration;
    }

    public int getMaxConcurrentThreads() {
        return this.accumulator.getMaxConcurrentThreads();
    }

    public long getSumOfSquares() {
        return this.accumulator.getSumOfSquares();
    }

    public Accumulator getAccumulator() {
        return this.accumulator;
    }

    public MethodKey getMethodKey() {
        return this.methodKey;
    }

    public Double getAverageDuration() {
        return this.accumulator.getAverageDuration();
    }

    public Double getStdDeviation() {
        return this.accumulator.getStdDeviation();
    }

    public long getTotalDuration() {
        return this.accumulator.getTotalDuration();
    }

    public int getConcurrentThreads() {
        return this.accumulator.getConcurrentThreads();
    }

    public long getTotalErrors() {
        return this.accumulator.getTotalErrors();
    }

    public long getTotalEnters() {
        return this.accumulator.getTotalEnters();
    }

    public long getTotalExits() {
        return this.accumulator.getTotalExits();
    }

    public long getMinDuration() {
        return this.accumulator.getMinDuration();
    }

    public long getMaxDuration() {
        return this.accumulator.getMaxDuration();
    }

    public boolean isRootNode() {
        return this.methodKey == null;
    }

    public String toString() {
        return this.isRootNode() ? "Root" : this.methodKey.getMethodName();
    }

    public Enumeration children() {
        return new ArrayEnumeration(this.childArray);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public javax.swing.tree.TreeNode getChildAt(int childIndex) {
        return this.childArray[childIndex];
    }

    public TraceTreeNode getChildNodeAt(int childIndex) {
        return this.childArray[childIndex];
    }

    public int getChildCount() {
        return this.childArray.length;
    }

    public javax.swing.tree.TreeNode getParent() {
        return this.parent;
    }

    public TraceTreeNode getParentNode() {
        return this.parent;
    }

    public int getIndex(javax.swing.tree.TreeNode node) {
        for (int i = 0; i < this.childArray.length; ++i) {
            if (node != this.childArray[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TotalChildrenComparator
    implements Comparator {
        private static final Comparator INSTANCE = new TotalChildrenComparator();

        private TotalChildrenComparator() {
        }

        public int compare(Object o1, Object o2) {
            TraceTreeNode stn1 = (TraceTreeNode)o1;
            TraceTreeNode stn2 = (TraceTreeNode)o2;
            int diff = stn1.totalChildren - stn2.totalChildren;
            return diff == 0 ? 0 : (diff < 0 ? 1 : -1);
        }
    }
}

