/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.shiftone.jrat.provider.tree.ui.TraceTreeNode;
import org.shiftone.jrat.provider.tree.ui.hierarchy.HierarchyModelBuilder;
import org.shiftone.jrat.provider.tree.ui.hierarchy.HierarchyPanel;
import org.shiftone.jrat.provider.tree.ui.summary.MethodSummaryModel;
import org.shiftone.jrat.provider.tree.ui.summary.SummaryPanel;
import org.shiftone.jrat.provider.tree.ui.summary.SummaryTableModel;
import org.shiftone.jrat.provider.tree.ui.trace.TracePanel;
import org.shiftone.jrat.util.log.Logger;

public class TraceViewPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$provider$tree$ui$TraceViewPanel == null ? (class$org$shiftone$jrat$provider$tree$ui$TraceViewPanel = TraceViewPanel.class$("org.shiftone.jrat.provider.tree.ui.TraceViewPanel")) : class$org$shiftone$jrat$provider$tree$ui$TraceViewPanel);
    private final JTabbedPane tabbedPane = new JTabbedPane();
    static /* synthetic */ Class class$org$shiftone$jrat$provider$tree$ui$TraceViewPanel;

    public TraceViewPanel(TraceTreeNode node, Set allMethodKeys, long sessionStartMs, long sessionEndMs, Properties systemProperties, String hostName, String hostAddress) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        long start = System.currentTimeMillis();
        MethodSummaryModel methodSummaryModel = new MethodSummaryModel(node);
        SummaryTableModel summaryTableModel = new SummaryTableModel(methodSummaryModel);
        this.tabbedPane.addTab("Summary", new SummaryPanel(summaryTableModel, methodSummaryModel.getTotalMethodDuration(), sessionStartMs, sessionEndMs, systemProperties, hostName, hostAddress));
        this.tabbedPane.addTab("Trace", new TracePanel(node));
        HierarchyModelBuilder builder = new HierarchyModelBuilder(methodSummaryModel, allMethodKeys);
        this.tabbedPane.addTab("Hierarchy", new HierarchyPanel(builder.getModel()));
        LOG.info("loaded in " + (System.currentTimeMillis() - start) + " ms");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

