/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui.hierarchy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.provider.tree.ui.hierarchy.HierarchyTreeTableModel;
import org.shiftone.jrat.provider.tree.ui.hierarchy.nodes.ClassHierarchyNode;
import org.shiftone.jrat.provider.tree.ui.hierarchy.nodes.MethodHierarchyNode;
import org.shiftone.jrat.provider.tree.ui.hierarchy.nodes.MethodSummaryHierarchyNode;
import org.shiftone.jrat.provider.tree.ui.hierarchy.nodes.PackageHierarchyNode;
import org.shiftone.jrat.provider.tree.ui.summary.MethodSummary;
import org.shiftone.jrat.provider.tree.ui.summary.MethodSummaryModel;

public class HierarchyModelBuilder {
    private final Map methodKeyNodes = new HashMap();
    private final Map packageNodes = new HashMap();
    private final PackageHierarchyNode root;
    private final MethodSummaryModel methodSummaryModel;

    public HierarchyModelBuilder(MethodSummaryModel methodSummaryModel, Set allMethodKeys) {
        this.root = new PackageHierarchyNode("", methodSummaryModel);
        this.methodSummaryModel = methodSummaryModel;
        Iterator i = methodSummaryModel.getMethodSummaryList().iterator();
        while (i.hasNext()) {
            this.addMethodSummary((MethodSummary)i.next());
        }
        i = allMethodKeys.iterator();
        while (i.hasNext()) {
            this.addMethod((MethodKey)i.next());
        }
        this.root.finalizeStatistics();
    }

    public HierarchyTreeTableModel getModel() {
        return new HierarchyTreeTableModel(this.getRoot());
    }

    public PackageHierarchyNode getRoot() {
        return this.root;
    }

    private void addMethod(MethodKey methodKey) {
        if (!this.methodKeyNodes.containsKey(methodKey)) {
            this.getClassNode(methodKey).addMethod(new MethodHierarchyNode(methodKey, this.methodSummaryModel));
        }
    }

    private void addMethodSummary(MethodSummary methodSummary) {
        MethodKey methodKey = methodSummary.getMethodKey();
        ClassHierarchyNode classNode = this.getClassNode(methodKey);
        MethodSummaryHierarchyNode node = new MethodSummaryHierarchyNode(methodSummary, this.methodSummaryModel);
        classNode.addMethod(node);
        this.methodKeyNodes.put(methodKey, node);
    }

    private ClassHierarchyNode getClassNode(MethodKey methodKey) {
        return this.getPackageNode(methodKey).getChildClass(methodKey.getClassName());
    }

    private PackageHierarchyNode getPackageNode(MethodKey methodKey) {
        PackageHierarchyNode node = (PackageHierarchyNode)this.packageNodes.get(methodKey.getPackageName());
        if (node == null) {
            node = this.root.getChildPackage(methodKey.getPackageNameParts());
            this.packageNodes.put(methodKey.getPackageName(), node);
        }
        return node;
    }
}

